import os
import sys
import glob
import argparse
import math
import string
from collections import namedtuple
from operator import attrgetter
import datetime

# psstools.ImportPSSE(33)
# psstools.EnableExceptions()
import psstools
import psspy
psspy.psseinit(100000)
import xlrd
import xlwt
import xlutils
from xlutils.copy import copy
import openpyxl
# import setHvdcDispatch
import setHvdcDispatch_state2

temp_sum = 0
WSCCArea = 15
test_index = 0 

_f, _i, _s = psspy._f, psspy._i, psspy._s 

# Branch = namedtuple("Branch", 'bus1 bus2 id')

def col2num(c):
    ###"""Return number corresponding to excel-style column."""
    number=-25
    for l in c:
        if not l in string.ascii_letters:
            return False
        number+=ord(l.upper())-64+25-1
		
    return number

def checkSolution():
    try:
        solved = psspy.solved()
        return {0: "Solved", 1: "Iteration limit exceeded", 2: "Blown up", 5: "Singular Jacobian or voltage of 0.0 detected"}[solved]
    except:
        return "Failed for reason %s" % solved

def solve_initial():
	psspy.solution_parameters_4([_i,50,_i,_i,10],[_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
	# psspy.fdns([0,0,0,1,0,0,99,0]) #### FDNS_Lock tap_ Lock Swicthed shunt
	# psspy.fdns([0,0,0,1,0,0,99,0]) #### FDNS_Lock tap_ Lock Swicthed shunt
	# psspy.fnsl([0,0,0,1,0,0,99,0]) #### FNSL_Lock tap_ Lock Swicthed shunt
	# psspy.fnsl([0,0,0,1,0,0,99,0]) #### FNSL_Lock tap_ Lock Swicthed shunt
	psspy.fnsl([0,0,0,1,2,0,99,0]) #### FNSL_Lock tap_ Enable SVC
	err = psspy.solved()
	assert err == 0

	return err

def Solve():
	def solve2():
		psspy.progress("\n FDNS - Lock tap Enable SVC Only\n")
		psspy.fdns([0,0,0,1,2,0,99,0])
		psspy.fdns([0,0,0,1,2,0,99,0])
		psspy.progress("\n FNSL - Lock tap Enable SVC Only\n")
		psspy.fnsl([0,0,0,1,2,0,99,0])
		psspy.fnsl([0,0,0,1,2,0,99,0])
	def solve1():
		psspy.progress("\n FNSL - Lock tap Enable SVC Only\n")
		psspy.fnsl([0,0,0,1,2,0,99,0])
		psspy.fnsl([0,0,0,1,2,0,99,0])
	def solve3():
		psspy.progress("\n FDNS - Lock tap Enable SVC Only\n")
		psspy.fdns([0,0,0,1,2,0,99,0])
		psspy.fdns([0,0,0,1,2,0,99,0])
		psspy.progress("\n FDNS - Lock tap Enable SVC Only\n")
		psspy.fdns([0,0,0,1,2,0,99,0])
		psspy.fdns([0,0,0,1,2,0,99,0])
		psspy.progress("\n FNSL - Lock tap Enable SVC Only\n")
		psspy.fnsl([0,0,0,1,2,0,99,0])
		psspy.fnsl([0,0,0,1,2,0,99,0])
	
	psspy.save("Saved_working_case_temp.sav")
	solve1()
	solved = psspy.solved()
	if solved != 0:
		psspy.case("Saved_working_case_temp.sav")
		solve2()
		solved = psspy.solved()
	if solved != 0:
		psspy.case("Saved_working_case_temp.sav")
		solve3()
		solved = psspy.solved()
	
	checkSol()

def checkSol():
	solved = psspy.solved()
	if solved == 0:
		psspy.progress("+++++++++++++++++++++++++ SOLVED PROPERLY +++++++++++++++++ \n")
		# print iterN
		# return solved
	# elif solved ==1 :
		# return solved
	else:
		print "Not Solved"
		solvedMsg = {0: "Solved", 1: "Iteration limit exceeded", 2: "Blown up", 5: "Singular Jacobian or voltage of 0.0 detected"}[solved]
		psspy.progress("+++++++++++++++++++++++++ NOT SOLVED PROPERLY +++++++++++++++++ \n")
		psspy.progress("+++++++++++++++++++++++++ NOT SOLVED PROPERLY +++++++++++++++++ \n")
		psspy.progress("+++++++++++  %s ++++++++++++ \n" %solvedMsg)
		
		raise solutionError(solvedMsg)
		
class solutionError(Exception):
	def __init__(self, solvedMsg):
		self.solvedMsg = solvedMsg
		
		
def Solve111():
	psspy.solution_parameters_4([_i,50,_i,_i,10],[_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
	psspy.fdns([0,0,0,1,0,0,99,0]) #### FDNS_Lock tap_ Lock Swicthed shunt
	psspy.fdns([0,0,0,1,0,0,99,0]) #### FDNS_Lock tap_ Lock Swicthed shunt
	psspy.fnsl([0,0,0,1,0,0,99,0]) #### FNSL_Lock tap_ Lock Swicthed shunt
	psspy.fnsl([0,0,0,1,0,0,99,0]) #### FNSL_Lock tap_ Lock Swicthed shunt
	psspy.fnsl([0,0,0,1,2,0,99,0]) #### FNSL_Lock tap_ Enable SVC
	psspy.fnsl([0,0,0,1,2,0,99,0]) #### FNSL_Lock tap_ Enable SVC
	# psspy.fnsl([1,0,0,1,1,0,99,0]) #### FNSL_Stepping_ Enable all Swicthed shunt
	# psspy.fnsl([1,0,0,1,1,0,99,0]) #### FNSL_Stepping_ Enable all Swicthed shunt
	err = psspy.solved()
	assert err == 0

	return err

def TieMeasure():
	Pm = 0
	
	for br in ab_bc:
		print br
		err, temp_flow = psspy.brnflo(br[0], br[1], br[2])
		Pm += temp_flow.real
	print "AB-BC :", Pm
	# sys.exit()
	# psstools.IgnoreErrorCodes = set()
	return -Pm.real

class Intertie(object):
	def __init__(self, branches=None):
		self.branches = branches
	
	def Measure(self):
		Pm = 0
		print Pm
		# psstools.IgnoreErrorCodes = set((3,))
		for br in ab_bc:
			print br
			err, temp_flow = psspy.brnflo(br[0], br[1], br[2])
			Pm += temp_flow.real
		print "AB-BC :", Pm
		# sys.exit()
		# psstools.IgnoreErrorCodes = set()
		return -Pm.real

class Case(object):
	flowEpsilon = 0.05
	scaleLoadsIterationLimit = 50
	includeMotors = True
	ignoreBaseCaseVoltageViolations = True
	ignoreBaseCaseBranchOverloads = True
	saskImport = 1473
	WSCCArea = 15
	marginalMW = 1
	minGenBeforeMarginal = 0.1
	ignorePmin = False
	ignorePmax = False
	swingBus = 1520
	# useIntertie = True  
	
	# def __init__(self, topologyCase, filename, intertie, MPIDs, MOList, loadData, loadMapping, tssData):
	def __init__(self, topologyCase, intertie, MPIDs, MOList, hourly_output_dir, month, state1_munit, s1_hvdcParameters):
		
		self.topologyCase = topologyCase
		self.MOList = MOList
		self.MPIDs = MPIDs
		self.hourly_output_dir = hourly_output_dir
		self.month = month
		self.state1_munit = state1_munit
		self.s1_hvdcParameters = s1_hvdcParameters
		self.s1OWSP = s1_hvdcParameters[0]
		self.s1OESP = s1_hvdcParameters[1]
		self.s1watlFlow = s1_hvdcParameters[2]
		self.s1eatlFlow = s1_hvdcParameters[3]
		# psspy.case(self.topologyCase)
		# Solve()
		print len(self.MOList)
		for eachemmo in self.MOList:
			MPID = self.findMU_MPID_info(eachemmo)
			if MPID == []:
				self.MOList.remove(eachemmo)
			
		print len(self.MOList)
		
	def findMU_MPID_info(self, eachemmo):
		MPID = []
		for eachMPID in self.MPIDs:
			if eachMPID.mpidName == eachemmo.assetName:
				MPID = eachMPID
				break
		# if MPID == []:
			# raise ValueError
		return MPID	
		
	def SetSwingBus(self):
		buses, types = psspy.abusint(-1, 1, ("NUMBER", "TYPE"))
		for bus, type in zip(buses, types):
			if type == 3:
				psspy.bus_chng_3(bus, (2, ))
				break
		psspy.bus_chng_3(self.swingBus, (3, ))
		
	def GetSwingBusMW(self):
		p = 0
		try:
			psspy.inimac(self.swingBus)
			psstools.IgnoreErrorCodes = set((4,))
			while True:
				id = psspy.nxtmac(self.swingBus)
				status = psspy.macint(self.swingBus, id, 'STATUS')
				if status == 1:
					p += psspy.macdat(self.swingBus, id, 'P')
		except :
			pass
		psstools.IgnoreErrorCodes = set()
		return p
		
	def MeasureSwingBus(self):
		psstools.IgnoreErrorCodes = set((4,))
		gen = psspy.gendat(self.swingBus).real
		psstools.IgnoreErrorCodes = set()
		return 
		
	def GetSystemTotals(self, excludeWSCC):
		# system99load = GetSystem99Load(excludeWSCC)
		ierr, totals2, motors2 = psspy.scal_2(0, 1, 0, (0, 0, 0, 0, 0), (0, 0, 0, 0, 0, 0, 0))
		motorLoad = -totals2[6]
		# totalLoad_99_plus_motor = system99load + motorLoad
		# print system99load, motorLoad
		if not excludeWSCC:
			err, load = psspy.systot("LOAD")
			err, gen = psspy.systot("GEN")
			err, loss = psspy.systot("LOSS") 
			err, alshnt = psspy.systot("ALSHNT") 
			
			status, pload, qload = getLoadData(1473, '34')
			if pload < 0:
				totalLoad = load.real - pload
			else:
				totalLoad = load.real
				
			# return load.real, gen.real, loss.real, alshnt.real
			return totalLoad, gen.real, loss.real, alshnt.real
		
		
		load_AIES, gen_AIES, loss_AIES, loss_alshnt = self.GetSystemTotals(False)
		# load_AIES, gen_AIES, loss_AIES, loss_alshnt = excludeWSCCinfo()
		err, load_wscc = psspy.ardat(WSCCArea, 'LOAD')
		err, gen_wscc = psspy.ardat(WSCCArea, 'GEN')
		err, loss_wscc = psspy.ardat(WSCCArea, 'LOSS')
		err, loss_alshnt = psspy.systot("ALSHNT")
		
		# print load_wscc, gen_wscc, loss_wscc, loss_alshnt
		# raw_input()
		# load_AIES = load_AIES - load_wscc.real
		# gen_AIES = gen_AIES - gen_wscc.real
		loss_AIES = loss_AIES - loss_wscc.real
		loss_alshnt = loss_alshnt.real
		loss_total_AIES = loss_AIES
		return load_AIES, gen_AIES, loss_total_AIES, loss_alshnt
		
	
	
	def FindMarginalUnit(self, LFMPID):  ###### Updated by SDR
		# MOList = GSOUnits
		
		MOList = self.MOList
		TotalDispatch = 0.0 # Initialize
		Load, Gen, Loss, ShuntLoss = self.GetSystemTotals(True)
		print Gen.real, (Load.real+Loss.real+ShuntLoss.real)
		TotalDemand = (Load.real+Loss.real+ShuntLoss.real)
		print "Real Total Demand ", TotalDemand
		
		def findMarginalUnit_MPID_info(MarginalUnit):
			MPID = []
			for eachMPID in self.MPIDs:
				if eachMPID.mpidName == MarginalUnit.assetName:
					MPID = eachMPID
					break
			# if MPID == []:
				# raise ValueError
			return MPID
			
		for eachMORecord in MOList:
			MPID = findMarginalUnit_MPID_info(eachMORecord)
			if MPID != []:
				TotalDispatch += eachMORecord.availablePower
				# print TotalDispatch
				# raw_input()
				if TotalDispatch > TotalDemand:
					MarginalUnit = eachMORecord
					MarginalUnitReserve = TotalDispatch-TotalDemand #GSOUnit.maxDispatchamount 
					break
					## What if MaxDispatch < Pgen(MPIDUnit)
					# UnitReserve = Pmax - Pgen
		# print "TotalDispatch:", TotalDispatch, "\nTotalDemand:", TotalDemand, "\nGSOUnit", GSOUnit.gsoNumber
		# sys.exit()
		
		print MarginalUnit.assetName, MarginalUnit.blockNumber
		
		assetname =  self.state1_munit.split("-")[0]
		blocknumber =  self.state1_munit.split("-")[1]
		
		if MarginalUnit.assetName != assetname and MarginalUnit.blockNumber != blocknumber:
			for eachMORecord in MOList:
				if eachMORecord.assetName == assetname and eachMORecord.blockNumber == blocknumber:
					MarginalUnit == eachMORecord
					print MarginalUnit.assetName, MarginalUnit.blockNumber
					break
		
			
		# raw_input()
		# if MarginalUnit.assetName == LFMPID or MarginalUnit.assetName == 'BCHIMP' or MarginalUnit.assetName == 'SPCIMP':
		if MarginalUnit.assetName == LFMPID :
			MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit(MarginalUnit, "NEXT", LFMPID)
		print MarginalUnit.assetName, MarginalUnit.blockNumber
		
		# raw_input()
		
		
		return MarginalUnit, MarginalUnitReserve
		
	def	 UpdateMarginalUnit(self, currentMarginalUnit, cntrl, LFMPID):
		# print "======UpdateMarginalUnit+++++++++ " , currentMarginalUnit.gsoMPID
		Match = False
		if cntrl == 'NEXT':
			for GSOUnit in self.MOList:      
				# print "Hello" , GSOUnit.gsoMPID, GSOUnit.gsoNumber
					
				if not Match:
					if GSOUnit.serial == currentMarginalUnit.serial:
						Match = True
					continue
				else :
					# if GSOUnit.assetName == 'BCHIMP' or GSOUnit.assetName == 'SPCIMP' or GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
					if GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
						continue
					
					# print "GSOUnit.gsoNumber - mpid", GSOUnit.gsoNumber , GSOUnit.gsoMPID
					
					return GSOUnit, GSOUnit.totalDisp_eachMPID
					break
				
		elif cntrl == 'PREV':
			for GSOUnit in reversed(self.MOList):    
				# print "Hello" , GSOUnit.gsoMPID, GSOUnit.gsoNumber
					
				if not Match:
					if GSOUnit.serial == currentMarginalUnit.serial:
						Match = True
					continue
				else :
					# if GSOUnit.assetName == 'BCHIMP' or GSOUnit.assetName == 'SPCIMP' or GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
					if GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
						continue
					
					# print "GSOUnit.gsoNumber - mpid", GSOUnit.gsoNumber , GSOUnit.gsoMPID
					
					return GSOUnit, 0
					break
	def	 UpdateMarginalUnit_caseprep(self, currentMarginalUnit, cntrl, LFMPID):
		# print "======UpdateMarginalUnit+++++++++ " , currentMarginalUnit.gsoMPID
		Match = False
		if cntrl == 'NEXT':
			for GSOUnit in self.MOList:      
				# print "Hello" , GSOUnit.gsoMPID, GSOUnit.gsoNumber
					
				if not Match:
					if GSOUnit.serial == currentMarginalUnit.serial:
						Match = True
					continue
				else :
					if GSOUnit.assetName == 'BCHIMP' or GSOUnit.assetName == 'SPCIMP' or GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
					# if GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
						continue
					
					# print "GSOUnit.gsoNumber - mpid", GSOUnit.gsoNumber , GSOUnit.gsoMPID
					
					return GSOUnit, GSOUnit.totalDisp_eachMPID
					break
				
		elif cntrl == 'PREV':
			for GSOUnit in reversed(self.MOList):    
				# print "Hello" , GSOUnit.gsoMPID, GSOUnit.gsoNumber
					
				if not Match:
					if GSOUnit.serial == currentMarginalUnit.serial:
						Match = True
					continue
				else :
					if GSOUnit.assetName == 'BCHIMP' or GSOUnit.assetName == 'SPCIMP' or GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
					# if GSOUnit.availablePower == 0 or GSOUnit.assetName == LFMPID:
						continue
					
					# print "GSOUnit.gsoNumber - mpid", GSOUnit.gsoNumber , GSOUnit.gsoMPID
					
					return GSOUnit, 0
					break			
			
			
	
	def sask_imp_adjustment(control, MPID):
		if control == 'Initialize':
			saskbus = 1473
			# psspy.plant_data(saskbus,0,[ 1.0, 100.0])
			# psspy.machine_data_2(saskbus,r"""3""",[_i,2,_i,_i,_i,_i],[ 0.0398,-0.3269, 1605.6,-1170.3, 2641.0,-87991.2, 1870.9, 0.12, 0.24,_f,_f,_f,_f,_f,_f,_f,_f])
			# psspy.seq_machine_data_3(saskbus,r"""3""",_i,[ 0.12, 0.24, 0.12, 0.24, 0.12, 0.24, 0.24, 0.24,_f,_f])
			status = 1
			psspy.machine_chng_2(saskbus,r"""3""",[status,_i,_i,_i,_i,_i],[0.0,0.0,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
			err, busvoltage = psspy.busdat(saskbus, 'PU')
			psspy.plant_chng(saskbus,_i,[busvoltage,_f])
		elif control == 'Finalize':
			totalPgen = 0
			totalQgen = 0
			for gen in MPID.generators:
				err, [pgen, qgen] = psspy.macdat(gen.bus, gen.id, ['P', 'Q'])
				err, [status] = psspy.macdat(gen.bus, gen.id, ['STATUS'])
				if status != 0 :
					totalPgen += pgen 
					totalQgen += qgen
			mismatch = totalPgen - 0
			while abs(mismatch) > flowTolerance:
				totalPload, totalQload = determineMPID_Load(MPID)
				PL = totalPgen - totalPload
				QL = totalQgen - totalQload
				for load in MPID.loads:
					psspy.load_chng_4(load.bus,load.id,[1,_i,_i,_i,_i,_i],[PL,QL,_f,_f,_f,_f])
				for gen in MPID.generators:
					psspy.machine_chng_2(gen.bus,gen.id,[_i,_i,_i,_i,_i,_i],[0.0,0.0,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
				Solve()
				totalPgen = 0
				totalQgen = 0
				for gen in MPID.generators:
					err, [pgen, qgen] = psspy.macdat(gen.bus, gen.id, ['P', 'Q'])
					err, [status] = psspy.macdat(gen.bus, gen.id, ['STATUS'])
					if status != 0 :
						totalPgen += pgen 
						totalQgen += qgen
				mismatch = totalPgen - 0
					
					
	
	def ProcessMPID(self, MPID):
		# psspy.startrecording(1, os.path.join(self.path, "%s.py" % mpidCaseName))
		
		# psspy.case(self.filename)
		# psspy.solution_parameters_4((psspy._i, 50), (psspy._f,) *5 + (0.01, ))

		def UpdateWorkingMPID(delta, workingMPID, control, fulldispatchamount=None):
			delta = abs(delta)
			MPID = workingMPID
			print MPID.mpidName
			if control == "Reduce":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print "pgen  : ", pgen
					if status != 0 :
						if delta>pgen:
							newpgen = 0
							newstatus = 0
							delta = delta - pgen
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
						elif delta<pgen:
							newpgen = pgen - delta
							delta = 0
							newstatus  = 1
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
						elif delta == pgen:
							newpgen = 0
							delta = 0
							newstatus = 0
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
			elif control == "Increase":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
					# raw_input("Increasing...")
					print delta
					if pgen < pmax:
						if (delta+pgen) > pmax:
							newpgen = pmax
							newstatus = 1
							delta = delta - (pmax - pgen)
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							
						else: ## delta < pmax
							newpgen = pgen + delta
							delta = 0
							newstatus = 1 
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateGen(gen.bus, gen.id, newpgen, newstatus)
							break
					else:
						continue
				if delta != 0 :
					print delta
					# raw_input("Could not dispatch all")
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
						if status != 0:
							newstatus = 1
							UpdateGen_Max(gen.bus, gen.id, pgen+delta, pgen+delta, newstatus)
							break
					
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				temp = 0
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax
					temp = temp + pgen
				print temp
				# raw_input()
					
			elif control == "SwitchOff":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					newpgen = 0
					newstatus = 0 
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
			elif control == "Full Dispatch":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					newpgen = pmax
					newstatus = 1
					UpdateGen(gen.bus, gen.id, newpgen, newstatus)
				totalPgen, totalPmax = determineMPID_Gen(MPID)
				print totalPgen, totalPmax
				# raw_input()
				if fulldispatchamount != totalPgen:
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					extra = fulldispatchamount - totalPgen
					print extra
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						newpgen = pmax
						newstatus = 1
						UpdateGen_Max(gen.bus, gen.id, pmax+extra, pmax+extra, newstatus)
		

		def UpdateWorkingLFMPID(delta, workingMPID, control, fulldispatchamount=None):
			delta = abs(delta)
			MPID = workingMPID
			print MPID.mpidName
			if control == "Reduce":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print "pgen  : ", pgen
					if status != 0 :
						if delta>pgen:
							newpgen = 0
							newstatus = 0
							delta = delta - pgen
							UpdateLF_Gen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
						elif delta<pgen:
							newpgen = pgen - delta
							delta = 0
							newstatus  = 1
							UpdateLF_Gen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
						elif delta == pgen:
							newpgen = 0
							delta = 0
							newstatus = 0
							UpdateLF_Gen(gen.bus, gen.id, newpgen, newstatus)
							# raw_input("=====")
							print "delta :", delta
							break
			elif control == "Increase":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
					# raw_input("Increasing...")
					print delta
					if pgen < pmax:
						if (delta+pgen) > pmax:
							newpgen = pmax
							newstatus = 1
							delta = delta - (pmax - pgen)
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateLF_Gen(gen.bus, gen.id, newpgen, newstatus)
							
						else: ## delta < pmax
							newpgen = pgen + delta
							delta = 0
							newstatus = 1 
							# raw_input("=====")
							print newpgen, newstatus, delta
							UpdateLF_Gen(gen.bus, gen.id, newpgen, newstatus)
							break
					else:
						continue
				if delta != 0 :
					print delta
					# raw_input("Could not dispatch all")
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						print gen.bus, gen.id, status, pgen, pmax, pmin, qmax, qmin, mbase
						if status != 0:
							newstatus = 1
							UpdateLF_Gen_Max(gen.bus, gen.id, pgen+delta, pgen+delta, newstatus)
							break
					
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				temp = 0
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					print gen.bus, gen.id, status, pgen, pmax
					temp = temp + pgen
				print temp
				# raw_input()
					
			elif control == "SwitchOff":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					newpgen = 0
					newstatus = 0 
					UpdateLF_Gen(gen.bus, gen.id, newpgen, newstatus)
			elif control == "Full Dispatch":
				mpidgenerators = MPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = False)
				for gen in sortedmpidgenerators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					newpgen = pmax
					newstatus = 1
					UpdateLF_Gen(gen.bus, gen.id, newpgen, newstatus)
				totalPgen, totalPmax = determineMPID_Gen(MPID)
				print totalPgen, totalPmax
				# raw_input()
				if fulldispatchamount != totalPgen:
					sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
					extra = fulldispatchamount - totalPgen
					print extra
					for gen in sortedmpidgenerators:
						status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
						newpgen = pmax
						newstatus = 1
						UpdateLF_Gen_Max(gen.bus, gen.id, pmax+extra, pmax+extra, newstatus)
		

		
			

		def UpdateSystem(deltaNetFlow, MarginalUnit, MarginalUnitReserve, MOList, control, LFMPID):
			
			print deltaNetFlow, MarginalUnit.assetName, MarginalUnitReserve, control, LFMPID
			
			
			for eachMPID in self.MPIDs:
				if eachMPID.mpidName == MarginalUnit.assetName:
					MPID = eachMPID
					break
			totalPgen, totalPmax = determineMPID_Gen(MPID)
			MarginalUnitReserve = MarginalUnit.totalDisp_eachMPID - totalPgen
			print "MarginalUnitReserve ", MarginalUnitReserve
			# raw_input()
			if MarginalUnit.assetName == 'BCHIMP':
				desiredSwingBus = assignSwingBus(MarginalUnit, LFMPID)
				# if control == "Increase":
				# delta = abs(deltaNetFlow)
				target_bctie = MarginalUnit.totalDisp_eachMPID
				minimum_bctie_blockValue = MarginalUnit.availablePower
				previous_target_bctie = target_bctie - minimum_bctie_blockValue
				Solve()
				current_bctie = TieMeasure()
				if current_bctie > target_bctie:
					mismatch = abs(current_bctie - target_bctie)
					while mismatch > flowTolerance:
						MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit(MarginalUnit, "NEXT", "")
						MarginalUnit, MarginalUnitReserve = UpdateSystem(mismatch, MarginalUnit, MarginalUnitReserve, MOList, "Increase", LFMPID)
						Solve()
						current_bctie = TieMeasure()
						mismatch = abs(current_bctie - target_bctie)
				elif current_bctie <= previous_target_bctie:
					mismatch = abs(current_bctie - previous_target_bctie)
					while mismatch > flowTolerance:
						MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit(MarginalUnit, "PREV", "")
						MarginalUnit, MarginalUnitReserve = UpdateSystem(mismatch, MarginalUnit, MarginalUnitReserve, MOList, "Reduce", LFMPID)
						Solve()
						current_bctie = TieMeasure()
						mismatch = abs(current_bctie - previous_target_bctie)
				if current_bctie <= target_bctie and current_bctie > previous_target_bctie:
					MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
			elif MarginalUnit.assetName == 'SPCIMP':
				MPID = findMarginalUnit_MPID_info(MarginalUnit)
				sask_imp_adjustment("Initialize", MPID)
				desiredSwingBus = assignSwingBus(MarginalUnit, LFMPID)
				target_sasktie = MarginalUnit.totalDisp_eachMPID
				minimum_sasktie_blockValue = MarginalUnit.availablePower
				previous_target_sasktie = target_sasktie - minimum_sasktie_blockValue
				Solve()
				MPID = findMarginalUnit_MPID_info(MarginalUnit)
				current_sasktie = determineMPID_Gen(MPID)
				mismatch = abs(current_sasktie - target_sasktie)
				if current_sasktie > target_sasktie:
					mismatch = abs(current_sasktie - target_sasktie)
					while mismatch > flowTolerance:
						MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit(MarginalUnit, "NEXT", "")
						MarginalUnit, MarginalUnitReserve = UpdateSystem(mismatch, MarginalUnit, MarginalUnitReserve, MOList, "Increase", LFMPID)
						Solve()
						current_sasktie = determineMPID_Gen(MPID)
						mismatch = abs(current_sasktie - target_sasktie)
				elif current_sasktie < previous_target_sasktie:
					mismatch = abs(current_sasktie - previous_target_sasktie)
					while mismatch > flowTolerance:
						MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit(MarginalUnit, "PREV", "")
						MarginalUnit, MarginalUnitReserve = UpdateSystem(mismatch, MarginalUnit, MarginalUnitReserve, MOList, "Reduce", LFMPID)
						Solve()
						current_sasktie = determineMPID_Gen(MPID)
						mismatch = abs(current_sasktie - previous_target_sasktie)
				if current_sasktie <= target_sasktie and current_sasktie >= previous_target_sasktie:
					MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
				sask_imp_adjustment("Finalize", MPID)
				
				
			else:
				if control == "Increase":
				# if deltaNetFlow<0:  #### Working MPID Ges was reduced to nullify the netFlow - Increase Total Gen Dispatch
					delta = abs(deltaNetFlow)
					
					for workingMUnit in MOList:
						if workingMUnit.serial == MarginalUnit.serial:
							MU_MPID = findMarginalUnit_MPID_info(MarginalUnit)
							if delta > MarginalUnitReserve:
								print "delta ", delta
								# raw_input()
								UpdateWorkingMPID(MarginalUnitReserve, MU_MPID, "Increase")
								
								
								# raw_input("====Wait===")
								delta = delta - MarginalUnitReserve
								MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit(MarginalUnit, "NEXT", LFMPID)
								MarginalUnitReserve = MarginalUnit.availablePower
								continue
							elif delta <= MarginalUnitReserve:
								print "delta ", delta
								# raw_input()
								UpdateWorkingMPID(delta, MU_MPID, "Increase")
								
								MarginalUnit = MarginalUnit
								MarginalUnitReserve = MarginalUnitReserve - delta
								delta = 0
								break
				
				elif control == "Reduce":
				# elif deltaNetFlow>0:  #### Working MPID Ges was reduced to nullify the netFlow - Increase Total Gen Dispatch
					delta = abs(deltaNetFlow)
					for workingMUnit in MOList:
						MU_MPID = findMarginalUnit_MPID_info(MarginalUnit)
						if workingMUnit.serial == MarginalUnit.serial:
							Pdisp = MarginalUnit.availablePower - MarginalUnitReserve
							print "Pdisp :", Pdisp
							# raw_input()
							if delta > Pdisp:
								UpdateWorkingMPID(Pdisp, MU_MPID, "Reduce")
								
								MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit(MarginalUnit, "PREV", LFMPID)
								MarginalUnitReserve = 0
								delta = delta - Pdisp
								# raw_input("=====")
								print "delta :", delta
								continue
							elif delta <= Pdisp:
								UpdateWorkingMPID(delta, MU_MPID, "Reduce")
								
								MarginalUnit = MarginalUnit
								MarginalUnitReserve = MarginalUnitReserve + delta
								delta = 0
								# raw_input("=====")
								print "delta :", delta
								break
		
			return MarginalUnit, MarginalUnitReserve
			
			
			
		def checkMarginalUnit(MarginalUnit, MOList, MPIDs):
			print MarginalUnit.assetName, "----", int(MarginalUnit.serial)
			for eachMPID in MPIDs:
				if eachMPID.mpidName == MarginalUnit.assetName:
					MPID = eachMPID
					break
			Pdisp, totalPmax = determineMPID_Gen(MPID)
			Pavailable = MarginalUnit.totalDisp_eachMPID    ###determineMU_Info(MarginalUnit)  ### Define
			Palready = MarginalUnit.totalDisp_eachMPID - MarginalUnit.availablePower
			print Pdisp, totalPmax, Pavailable   
			# raw_input("--------------------")
			
			if Pdisp > Palready and Pdisp < Pavailable:
				delta = 0
				return delta, MarginalUnit
			elif Pdisp < Palready:
				control = "Increase"
				print "-----", control
				delta = abs(Palready - Pdisp)
				UpdateWorkingMPID(0, MPID, control)
				MarginalUnit, xx = self.UpdateMarginalUnit(MarginalUnit, "PREV", LFMPID)
				return delta, MarginalUnit
			elif Pdisp > Pavailable:
				control = "Reduce"
				print "-----", control
				delta = abs(Pavailable - Pdisp)
				UpdateWorkingMPID(delta, MPID, control)
				MarginalUnit, xx = self.UpdateMarginalUnit(MarginalUnit, "NEXT", LFMPID)
				return delta, MarginalUnit
		
		def checkMarginalUnit_Mismatch(MarginalUnit):
			print MarginalUnit.assetName, "----", int(MarginalUnit.serial)
			for eachMPID in self.MPIDs:
				if eachMPID.mpidName == MarginalUnit.assetName:
					MPID = eachMPID
					break
			Pdisp, totalPmax = determineMPID_Gen(MPID)
			Ptotal_uptoCurrentBlock = MarginalUnit.totalDisp_eachMPID    ###determineMU_Info(MarginalUnit)  ### Define
			Ptotal_previousBlock = MarginalUnit.totalDisp_eachMPID - MarginalUnit.availablePower
			
			print Pdisp, Ptotal_uptoCurrentBlock, Ptotal_previousBlock
			mismatch = 0 
			if Pdisp > Ptotal_uptoCurrentBlock:
				mismatch = Pdisp - Ptotal_uptoCurrentBlock
			elif Pdisp <= Ptotal_uptoCurrentBlock and Pdisp >= Ptotal_previousBlock:
				mismatch = 0
			elif Pdisp < Ptotal_previousBlock:
				mismatch = Pdisp - Ptotal_previousBlock

			return mismatch
			

		def assignSwingBus(MarginalUnit, LFMPID):
			print " +==== Asigning Swing Bus +++++++++ "
			# raw_input()
			if MarginalUnit.assetName == 'BCHIMP':
				desiredSwingBus = 1520
			elif MarginalUnit.assetName == 'SPCIMP':
				desiredSwingBus = 1473
			else:
				munitMPID = findMarginalUnit_MPID_info(MarginalUnit)
				mpidgenerators = munitMPID.generators
				sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
				for gen in sortedmpidgenerators:
					print gen.bus, gen.id
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id) ##(gen.bus, gen.id)
					if status != 0 :
						desiredSwingBus = gen.bus
						break
			# raw_input()
			for eachmpid in self.MPIDs:
				if eachmpid.mpidName == LFMPID:
					MPID = eachmpid
					print LFMPID
					break
			working_mpid_generators = MPID.generators
			# sortedmpidgenerators = sorted(mpidgenerators, key=attrgetter('id'), reverse = True)
			workingmpid_gen_buses = []
			for gen in working_mpid_generators:
				print gen.bus, gen.id
				workingmpid_gen_buses.append(gen.bus)
			
			print workingmpid_gen_buses
			print "===== Desired Sw bus : ", desiredSwingBus
			
			# raw_input()
			if desiredSwingBus in workingmpid_gen_buses:
				raise
			else:
				############ Change the previous swing bus back to Type - 2
				err, [buses, types] = psspy.abusint(-1, 1, ("NUMBER", "TYPE"))
				for bus, type in zip(buses, types):
					if type == 3:
						print "Prev. Swing Bus - ", bus
						psspy.bus_chng_3(bus, (2, ))
						if bus == 1473:
							# psspy.machine_chng_2(1473,r"""3""",[0,_i,_i,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f,_f])
							psspy.purgmac(1473,r"""3""")
						break
				####  Assign new swing Bus -- Type Code 3
				print "New Swing Bus : ", desiredSwingBus 
				psspy.bus_chng_3(desiredSwingBus,[3,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
				Solve()
				return desiredSwingBus
			
		def findMarginalUnitReserve(MarginalUnit):
			MPID = findMarginalUnit_MPID_info(MarginalUnit)
			totalPgen, totalPmax = determineMPID_Gen(MPID) 
			MarginalUnitReserve = MarginalUnit.totalDisp_eachMPID - totalPgen
			print "MarginalUnitReserve : ", MarginalUnitReserve
			return MarginalUnitReserve
		
		def findMarginalUnit_MPID_info(MarginalUnit):
			MPID = []
			for eachMPID in self.MPIDs:
				if eachMPID.mpidName == MarginalUnit.assetName:
					MPID = eachMPID
					break
			# if MPID == []:
				# raise ValueError
			return MPID
		
		def bctiematch(deltaFlow, MarginalUnit, MarginalUnitReserve):
			mismatch = deltaFlow
			iterationNumber = 1
			while abs(mismatch) > flowTolerance and iterationNumber < iterationLimit:   #### Reduced Gen in Working MPID - Dispatch Up Total Gen from Merit Order
				
				if mismatch > 0:
					control = "Increase"
				elif mismatch < 0:
					control = "Reduce"
				# print MarginalUnit.serial, MarginalUnit.assetName, MarginalUnitReserve
				# raw_input()
				MarginalUnit, MarginalUnitReserve = UpdateSystem(mismatch, MarginalUnit, MarginalUnitReserve, self.MOList, control, "")
				Solve()
				mismatch = TieMeasure()
				iterationNumber += 1
			
			if abs(mismatch) > flowTolerance and iterationNumber >= iterationLimit:
				raise 
			else:
				print mismatch
				MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
				print MarginalUnit.serial, MarginalUnit.assetName, MarginalUnitReserve
				return MarginalUnit
		
		def casePrep():
			Load, Gen, Loss, ShuntLoss = self.GetSystemTotals(True)
			TotalDemand = Load + Loss + ShuntLoss
			print Load, Loss, TotalDemand
			# raw_input()
			TotalDispatch = 0
			bctie = 0 ### initial bctie
			# print 
			############ turnoff_all_gens()
			buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases = FindAllMachineData(sid = -1, flag = 4)
			for bus, id, status, pgen, pmax, pmin, qmax, qmin, mbase in zip(buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases):
				if bus != 1520:
					UpdateGen(bus, id, 0, 0)
			UpdateLoad(1473, '34', 0, 0, 0)
			
			# while TotalDispatch < TotalDemand:
			for mUnit in self.MOList:
				if TotalDispatch < TotalDemand:
					MPID = findMarginalUnit_MPID_info(mUnit)
					if MPID != []:
						TotalDispatch += mUnit.availablePower
						print TotalDispatch 
						print int(mUnit.serial), " ----- ", mUnit.assetName,  mUnit.availablePower
						# raw_input()
						
						# raw_input("-----------")
						if mUnit.assetName == 'BCHIMP':
							bctie = mUnit.totalDisp_eachMPID
							MarginalUnit = mUnit
							continue
						elif mUnit.assetName == 'SPCIMP':
							bus = 1473
							id = '34'
							pload = -mUnit.totalDisp_eachMPID
							if pload !=0:
								status =  1
							else:
								status = 0
							err = psspy.load_chng_4(bus, id, (status,_i,_i,_i,_i,_i), (pload, _f, _f,_f,_f,_f)  )
							MarginalUnit = mUnit
						else:
							# if MPID != []:
							totalPgen, totalPmax = determineMPID_Gen(MPID)
							delta = totalPgen -  mUnit.totalDisp_eachMPID
							print delta
							MarginalUnit = mUnit
							# raw_input()
							if delta > 0:
								UpdateWorkingMPID(abs(delta), MPID, "Reduce", fulldispatchamount=None)
							elif delta < 0 :
								UpdateWorkingMPID(abs(delta), MPID, "Increase", fulldispatchamount=None)
							else:
								continue
						# psspy.save("2017LF_Dec01_HH1400_BaseCase.sav")
						# raw_input('=====Saved=====')
				else:
					break
			print "================================================"
			print "TotalDemand, TotalDispatch : ", TotalDemand, TotalDispatch
			# print temp_sum
			Load, Gen, Loss, ShuntLoss = self.GetSystemTotals(True)
			print Gen, Load+Loss+ShuntLoss
			# psspy.save("2017LF_Dec01_DispatchedGenProcessing.sav")
			# psspy.case("2017LF_Dec01_HH1400_BaseCase.sav")
			# raw_input("=================================================")
			# sys.exit()

			Solve()
			# psspy.save("2017LF_Dec01_HH1400_BaseCase.sav")
			Load, Gen, Loss, ShuntLoss = self.GetSystemTotals(True)
			print Gen.real, (Load.real+Loss.real+ShuntLoss.real)
			
			# MarginalUnit = mUnit
			MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
			mismatch = (TieMeasure() - bctie)
			# MarginalUnit, MarginalUnitReserve = UpdateSystem(mismatch, MarginalUnit, MarginalUnitReserve, self.MOList, control, "")
			# mismatch = (TieMeasure() - bctie)
			print "mismatch = ", mismatch
			print "MarginalUnit : ", MarginalUnit.assetName, MarginalUnit.serial, MarginalUnitReserve
			# raw_input("=============================================")
			
			print mismatch
			while abs(mismatch) > flowTolerance :   #### Reduced Gen in Working MPID - Dispatch Up Total Gen from Merit Order
				if MarginalUnitReserve == 0 and mismatch >0 :
					MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit_caseprep(MarginalUnit, "NEXT", "")
				elif MarginalUnitReserve == MarginalUnit.totalDisp_eachMPID and mismatch < 0:
					MarginalUnit, MarginalUnitReserve = self.UpdateMarginalUnit_caseprep(MarginalUnit, "PREV", "")
				if mismatch > 0:
					control = "Increase"
				elif mismatch < 0:
					control = "Reduce"
				print MarginalUnit.serial, MarginalUnit.assetName, MarginalUnitReserve
				# raw_input()
				MarginalUnit, MarginalUnitReserve = UpdateSystem(mismatch, MarginalUnit, MarginalUnitReserve, self.MOList, control, "")
				Solve()
				mismatch = (TieMeasure() - bctie)
				print MarginalUnit.serial, MarginalUnit.assetName, MarginalUnitReserve
				MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
				print "MarginalUnitReserve : ", MarginalUnitReserve
				print "mismatch : ", mismatch
				# psspy.save("2017LF_Dec01_HH1400_BaseCase.sav")
				# raw_input()
			print mismatch
			MarginalUnitReserve = findMarginalUnitReserve(MarginalUnit)
			print MarginalUnit.serial, MarginalUnit.assetName, MarginalUnitReserve
			# deltaNetFlow, MarginalUnit = checkMarginalUnit(MarginalUnit, self.MOList, self.MPIDs)
			return MarginalUnit.serial, MarginalUnit.assetName
		
		def initializeLoad():
			#################
			def isdLoadMapping(loadMapping):
				
				isdLoadList = []
				for eachload in loadMapping:
					if eachload.isdtag == "ISD" or eachload.isdtag == "ISD-New":
						bus_id = str(eachload.bus) + "-" + str(eachload.id)
						isdLoadList.append(bus_id)
				
				for row in isdLoadList:
					print row
					
					
				return isdLoadList
				
			def TurnOffLoads(isdLoadList):
				buses, ids, statuses, loads = FindAllLoadData()
				for bus, id, status, load in zip(buses, ids, statuses, loads):
					bus_id = str(bus) + "-" + str(id)
					if bus_id not in isdLoadList:
						UpdateLoad(bus, id, 0, 0, 0)
				
			def AssignLoads(loadData, loadMapping):
				# loadMPID, bus, id
				loadmpids = [] 
				for eachloadMPID in loadMapping:
					loadmpids.append(eachloadMPID.loadMPID)
				
				loads_in_loadmpids = dict()
				for eachloadMPID in loadMapping:
					number_of_loads = loadmpids.count(eachloadMPID.loadMPID)
					loads_in_loadmpids[eachloadMPID.loadMPID] = number_of_loads
					print eachloadMPID.loadMPID, loads_in_loadmpids[eachloadMPID.loadMPID]
				
				for eachloadMPID in loadMapping:
					if eachloadMPID.isdtag == "ISD" or  eachloadMPID.isdtag == 'ISD-New': 
						###### SKIP ISD LOads
						continue
					else:
						workingloadmpid = eachloadMPID.loadMPID
						loadbus = eachloadMPID.bus
						loadid = eachloadMPID.id
						number_of_loads = loads_in_loadmpids[workingloadmpid]
						mwData = 0
						for eachloadmpidData in loadData:
							#mpidName, mwData
							if eachloadmpidData.mpidName == workingloadmpid:
								mwData = eachloadmpidData.mwData
								break
						pf = 0.9
						pload = mwData/number_of_loads
						qload = pload * math.tan(math.acos(pf))
						print workingloadmpid, pload, qload, loadbus, loadid
						
						if pload != 0:
							status = 1
						else:
							status = 0
						UpdateLoad(loadbus, loadid, status, pload, qload)
						# raw_input()
			
			isdLoadList = isdLoadMapping(self.loadMapping)
			TurnOffLoads(isdLoadList)
			AssignLoads(self.loadData, self.loadMapping)
		
		def AssignISDLoads(tssData, loadMapping, MPIDs):
			# loadMPID, bus, id
			loadmpids = [] 
			for eachMPID in MPIDs:
				if (eachMPID.ISDtag == 'ISD'):
					loadmpid = eachMPID.loadmpid
					genMPID = eachMPID.mpidName
					
					emmo_pgen, pmax = determineMPID_Gen(eachMPID)
					
					mwData_tss = 0
					for eachloadmpidData in tssData:
						#mpidName, mwData
						if eachloadmpidData.mpidName == loadmpid:
							mwData_tss = eachloadmpidData.mwData
							break
					if emmo_pgen >= mwData_tss:
						isd_load_mw = emmo_pgen - mwData_tss
					else:
						isd_load_mw = 0
					pf = 0.9
					if len(eachMPID.loads) != 0:
						pload = isd_load_mw/len(eachMPID.loads)
						qload = pload * math.tan(math.acos(pf))
					
						if pload != 0:
							status = 1
						else:
							status = 0
						for load in eachMPID.loads:
							UpdateLoad(load.bus, load.id, status, pload, qload)
					# raw_input()			
			
		
		#########################################
		def basecaseprep():
			psspy.case(self.topologyCase)
			# psspy.case("2017LF_Dec01_BaseCase_Ready.sav")
			psspy.solution_parameters_4((psspy._i, 50), (psspy._f,) *5 + (0.01, ))
			
			tempname = self.outputCaseName.split(".sav")[0]
			initializeLoad()
			psspy.save(tempname + "_initializedload.sav")
			
			# raw_input("==========Initialized Loads=============")
			
			MUserial, MUassetName = casePrep()
			psspy.save(tempname + "_initializedload_genDispatch1.sav")
			# raw_input("==========Dispatched Gens=============")
			Load, Gen, Loss, ShuntLoss = self.GetSystemTotals(True)
			currentDemand = Load+Loss
			demandMismatch = currentDemand
			
			while abs(demandMismatch) > 0.5:
			# while abs(demandMismatch) > flowTolerance:
				AssignISDLoads(self.tssData, self.loadMapping, self.MPIDs)
				psspy.save(tempname + "_initializedload_genDispatch1_ISDLoad.sav")
				# raw_input("==========Assigned ISD Loads =============")
				MUserial, MUassetName = casePrep()
				Solve()
				psspy.save(tempname + "_initializedload_genDispatch1_ISDLoad_Redispatch.sav")
				Load, Gen, Loss, ShuntLoss = self.GetSystemTotals(True)
				currentDemand_new = Load+Loss
				demandMismatch = currentDemand_new - currentDemand
				currentDemand = currentDemand_new
				
				print demandMismatch, currentDemand_new
				# raw_input()
			
			psspy.save(self.outputCaseName)
			Load, Gen, Loss, ShuntLoss = self.GetSystemTotals(True)
			
			
			print Gen.real, Load.real, Loss.real+ShuntLoss.real, (Load.real+Loss.real+ShuntLoss.real)
			print("======     BASE CASE PREP - DONE ===============")
			

			return MUserial, MUassetName
		
		def hvdcDispatch():
			print "HVDC Dispatch ...................."
			psspy.progress("\n\n===================================== HVDC Dispatch ==============================================\n")
			caseName = os.path.basename(self.topologyCase)
			outputCaseName = caseName.split(".sav")[0] + "_" + MPID.mpidName + "_BeforeHVDC.sav"
			outputCaseName = os.path.join(self.hourly_output_dir, outputCaseName)
			psspy.save(outputCaseName)
			
			# try:
			# import setHvdcDispatch
			# setHvdcDispatch.hvdcMain(self.month, self.s1_hvdcParameters)
			savedOWSP, savedOESP, newWATL, newEATL = setHvdcDispatch_state2.hvdcMain(self.month, self.s1_hvdcParameters)
			Solve()
			print "==================HVDC Dispatch Done=========="
			psspy.progress("\n ==================HVDC Dispatch Done==========  \n")
			
			caseName = os.path.basename(self.topologyCase)
			outputCaseName = caseName.split(".sav")[0] + "_" + MPID.mpidName + "_AfterHVDC.sav"
			outputCaseName = os.path.join(self.hourly_output_dir, outputCaseName)
			psspy.save(outputCaseName)
				
			return savedOWSP, savedOESP, newWATL, newEATL
				
		def fineTuneMU_System(marginalUnitMismatch, MarginalUnit, MarginalUnitReserve, LFMPID):
			print "Fine tuning MUnit............"
			
			iterLimit = 20
			iterationNumber = 0
			while abs(marginalUnitMismatch) > 0.5 and iterationNumber < iterLimit:
				deltaGen = marginalUnitMismatch
				MU_MPID = findMarginalUnit_MPID_info(MarginalUnit)
				print("Adjusting Current MU inside the EMMO dispatch level.....")
				# raw_input()
				if deltaGen > 0:
					# raw_input("Reduce LF gen")
					print ("Reduce LF gen")
					UpdateWorkingMPID(abs(deltaGen), MU_MPID, "Reduce")  
				elif deltaGen < 0:
					print ("Increase LF gen")
					UpdateWorkingMPID(abs(deltaGen), MU_MPID, "Increase")
				print("Updating the system accordin to the Merit order.....")
				
				# raw_input()
				if deltaGen > 0 :
					control = "Increase"
					print "Increase System Total Gen"
				elif deltaGen < 0:
					control = "Reduce" 
					print "Reduce System Total Gen"
				MarginalUnit, MarginalUnitReserve = UpdateSystem(abs(deltaGen), MarginalUnit, MarginalUnitReserve, self.MOList, control, LFMPID)
				# MarginalUnit, MarginalUnitReserve = UpdateSystem(abs(deltaGen), MarginalUnit, MarginalUnitReserve, self.MOList, control, LFMPID)
				print "MU serial, AssetName, blockNumber :", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber
				print "totalDisp_eachMPID, MarginalUnitReserve, AvailablePower : ", MarginalUnit.totalDisp_eachMPID, MarginalUnitReserve, MarginalUnit.availablePower
				print("Updating swing bus.....")
				# raw_input()
				desiredSwingBus = assignSwingBus(MarginalUnit, LFMPID)
				Solve()
				marginalUnitMismatch = checkMarginalUnit_Mismatch(MarginalUnit)
				print "marginalUnitMismatch : ", marginalUnitMismatch
				# raw_input()
				iterationNumber += 1
				
				
			return 	marginalUnitMismatch, MarginalUnit	
		#############################
		########################################
		#######################################################
		
		### Create PSSE Progress Files ###
		caseName = os.path.basename(self.topologyCase)
		psselogFileName = "Progress_" + caseName.split(".sav")[0] + "_" + MPID.mpidName +".log"
		psselogFile = os.path.join(self.hourly_output_dir, psselogFileName)
		psspy.progress_output(2,psselogFile,[0,0])
		
		###### Open Case ##########
		psspy.progress("\n\n===================================== Opening the case ==============================================\n")
		psspy.case(self.topologyCase)
		psspy.solution_parameters_4((psspy._i, 50), (psspy._f,) *5 + (0.01, ))
		# Solve()
		solve_initial()
		#### Get State-1 Info #######
		################
		##########
		initialLoad, initialGen, initialLoss, initialShuntLoss = self.GetSystemTotals(True)
		loss_init = initialLoss.real + initialShuntLoss.real
		initial_totalMPIDLoss = determine_mpidInternalLoss(self.MPIDs)
		netloss_init = loss_init - initial_totalMPIDLoss
		
		psspy.progress("\n\n===================================== Finding State-1 MU ==============================================\n")
		LFMPID = MPID.mpidName
		MarginalUnit, MarginalUnitReserve = self.FindMarginalUnit(LFMPID)
		initialMarginalUnit = MarginalUnit
		# initMUName = initialMarginalUnit.assetName + " - " + str(int(initialMarginalUnit.serial))
		initMUName = initialMarginalUnit.assetName + " - " + str(int(initialMarginalUnit.blockNumber))
		print LFMPID
		print "MarginalUnit :" , MarginalUnit.serial, MarginalUnit.assetName
		print "MarginalUnitReserve : ", MarginalUnitReserve
		print "Working on - ", MPID.mpidName
		# raw_input("========================================")
		
		solve_initial()
		AB_BC_Tie = TieMeasure()
		print "BC Tie Flow: ", AB_BC_Tie
		
		initialmpidNetFlow = determineMPID_netFlow(MPID)
		initialmpidNetFlow = round(initialmpidNetFlow, 4)
		print " Initial NTG : ", initialmpidNetFlow
		
		
		init_watl = setHvdcDispatch_state2.getWATL_Dispatch()
		init_eatl = setHvdcDispatch_state2.getEATL_Dispatch()
		
		# raw_input()
		
		
		if initialmpidNetFlow >= 1: #### Check if State-2 is required ? ########
			
			################ Produce State-2 Cases ######
			##########################
			try:
				# psspy.save("Before State-1.sav")
				# psspy.save("Sample-0.sav")
				# raw_input("Saved - Changed Swing Bus")
				# raw_input("=================Begin State 2 ================")
				if MPID.mpidName == 'BCHIMP':
					# bctie_current = TieMeasure()
					bctie_current = initialmpidNetFlow
					bctie_final = 0
					# initmpidInternalLoss = 0
					deltaNetFlow = bctie_current - bctie_final
					MarginalUnit = bctiematch(deltaNetFlow, MarginalUnit, MarginalUnitReserve)
					marginalUnitMismatch = checkMarginalUnit_Mismatch(MarginalUnit)
					print "marginalUnitMismatch : ", marginalUnitMismatch
					marginalUnitMismatch, MarginalUnit = fineTuneMU_System(marginalUnitMismatch, MarginalUnit, MarginalUnitReserve, LFMPID)
					savedOWSP, savedOESP, newWATL, newEATL = hvdcDispatch()
					Solve()
					# raw_input("=============")
					marginalUnitMismatch = checkMarginalUnit_Mismatch(MarginalUnit)
					print "marginalUnitMismatch : ", marginalUnitMismatch
					marginalUnitMismatch, MarginalUnit = fineTuneMU_System(marginalUnitMismatch, MarginalUnit, MarginalUnitReserve, LFMPID)
					# initialmpidNetFlow = bctie_current
					# finalmpidNetFlow = determineMPID_netFlow(MPID)
					# initmpidInternalLoss = 0
					# finalmpidInternalLoss = 0
					finalMU = MarginalUnit
					final_marginalUnitMismatch = marginalUnitMismatch
					finalMUName = finalMU.assetName + " - " + str(int(finalMU.blockNumber))
					
				elif MPID.mpidName == 'SPCIMP': ##and MPID.mpidName != 'MATLIMP': # Not BC Intertie (has swing bus): 
					# data = [MPID.mpidName, '', '','','','','','','','','','','','','', ]
					# return data
					# mpidLoad, mpidQ = determineMPID_Load(MPID)
					# initialmpidNetFlow = -mpidLoad
					finalmpidNetFlow = 0
					deltaNetFlow = initialmpidNetFlow - finalmpidNetFlow
					
					for load in MPID.loads:
						psspy.load_chng_4(load.bus,load.id,[0,_i,_i,_i,_i,_i],[0,0,_f,_f,_f,_f])
						
					if abs(deltaNetFlow)>flowTolerance:
						if deltaNetFlow >= 0 :
							control = "Increase"
							print control
						elif deltaNetFlow < 0:
							control = "Reduce"
							print control
						MarginalUnit, MarginalUnitReserve = UpdateSystem(abs(deltaNetFlow), MarginalUnit, MarginalUnitReserve, self.MOList, control, LFMPID)
						desiredSwingBus = assignSwingBus(MarginalUnit, LFMPID)
						Solve()
						
						marginalUnitMismatch = checkMarginalUnit_Mismatch(MarginalUnit)
						print "marginalUnitMismatch : ", marginalUnitMismatch
						marginalUnitMismatch, MarginalUnit = fineTuneMU_System(marginalUnitMismatch, MarginalUnit, MarginalUnitReserve, LFMPID)
						savedOWSP, savedOESP, newWATL, newEATL = hvdcDispatch()
						Solve()
						# raw_input("=============")
						marginalUnitMismatch = checkMarginalUnit_Mismatch(MarginalUnit)
						print "marginalUnitMismatch : ", marginalUnitMismatch
						marginalUnitMismatch, MarginalUnit = fineTuneMU_System(marginalUnitMismatch, MarginalUnit, MarginalUnitReserve, LFMPID)
						finalMU = MarginalUnit
						final_marginalUnitMismatch = marginalUnitMismatch
					else:
						finalMU = MarginalUnit
						final_marginalUnitMismatch = 0
					
					# initmpidInternalLoss = 0
					# finalmpidInternalLoss = 0
					# finalmpidNetFlow = determineMPID_netFlow(MPID)
					finalMUName = finalMU.assetName + " - " + str(int(finalMU.blockNumber))
				
				else:
					
					mpidLoad, mpidQ = determineMPID_Load(MPID)
					mpidGen, mpidPmax = determineMPID_Gen(MPID)
					mpidNetflow = determineMPID_netFlow(MPID)
					initialmpidNetFlow = mpidNetflow
					targetMpidNetFlow = 0
					deltaNetFlow = mpidNetflow - targetMpidNetFlow
					marginalUnitMismatch = 0
					print " mpidNetflow :", mpidNetflow
					# if MPID.ISDtag == 'ISD':
					# raw_input()
					iterationNumber = 1
					# while abs(deltaNetFlow) > flowTolerance and iterationNumber < iterationLimit:
					psspy.progress("\n\n===================================== State-2 Iterations ==============================================\n")
					
					if MPID.ISDtag == "DOS":
						print "Processing DOS"
						psspy.progress("==========================Progressing DOS ====================")
						# raw_input()
						
						if deltaNetFlow > 0:
							print ("Reduce LF gen")
							# UpdateWorkingMPID(abs(deltaNetFlow), MPID, "Reduce")  
							if MPID.loads != []:
								for load in MPID.loads:
									print "BUS_ID", load.bus, load.id
									p = 0
									q = 0
									status = 0
									UpdateLoad(load.bus, load.id, status, p, q)
						
						deltaGen = deltaNetFlow
						# mismatch = deltaNetFlow
						print "deltaGen : ", deltaGen
						
						control = "Reduce" 
						print "Reduce System Total Gen"
						MarginalUnit, MarginalUnitReserve = UpdateSystem(abs(deltaGen), MarginalUnit, MarginalUnitReserve, self.MOList, control, LFMPID)
						print MarginalUnit.serial, MarginalUnit.assetName
						print MarginalUnit.totalDisp_eachMPID, MarginalUnitReserve, MarginalUnit.availablePower
						# raw_input()
						################################
						
						desiredSwingBus = assignSwingBus(MarginalUnit, LFMPID)
						Solve()
						mpidNetflow = determineMPID_netFlow(MPID)
						deltaNetFlow = mpidNetflow - targetMpidNetFlow
						print "State-2 deltaNetFlow : ", mpidNetflow
						# psspy.save("Sate2-Sample-0.sav")
						# raw_input("Saved - Changed Swing Bus")
						
						marginalUnitMismatch = checkMarginalUnit_Mismatch(MarginalUnit)
						print "marginalUnitMismatch : ", marginalUnitMismatch
						marginalUnitMismatch, MarginalUnit = fineTuneMU_System(marginalUnitMismatch, MarginalUnit, MarginalUnitReserve, LFMPID)
						savedOWSP, savedOESP, newWATL, newEATL = hvdcDispatch()
						Solve()
						# raw_input("=============")
						marginalUnitMismatch = checkMarginalUnit_Mismatch(MarginalUnit)
						print "marginalUnitMismatch : ", marginalUnitMismatch
						marginalUnitMismatch, MarginalUnit = fineTuneMU_System(marginalUnitMismatch, MarginalUnit, MarginalUnitReserve, LFMPID)
						
						
						# raw_input('=========================check========================')
						# mpidGen, mpidGen_pmax = determineMPID_Gen(MPID)
						
						
						# iterationNumber += 1
					else:
						
						
						######################## Making Working MPID NTG to zero #########
						
						if deltaNetFlow > 0:
							# raw_input("Reduce LF gen")
							print ("Reduce LF gen")
							UpdateWorkingLFMPID(abs(deltaNetFlow), MPID, "Reduce")  
						elif deltaNetFlow < 0:
							print "NTG < 0 MW (Target)"
							# break
							# print ("Increase LF gen")
							# UpdateWorkingMPID(abs(deltaNetFlow), MPID, "Increase")
							
						# mpidGen_new, mpidGen_pmax = determineMPID_Gen(MPID)
						# deltaGen = mpidGen - mpidGen_new
						deltaGen = deltaNetFlow
						print "deltaGen : ", deltaGen, deltaNetFlow
						# raw_input()
						#### Dispatch Up Total Gen from Merit Order
						if deltaGen > 0 :
							control = "Increase"
							print "Increase System Total Gen"
						elif deltaGen < 0:
							control = "Reduce" 
							print "Reduce System Total Gen"
						MarginalUnit, MarginalUnitReserve = UpdateSystem(abs(deltaGen), MarginalUnit, MarginalUnitReserve, self.MOList, control, LFMPID)
						print "MU serial, AssetName, blockNumber :", MarginalUnit.serial, MarginalUnit.assetName, MarginalUnit.blockNumber
						print "totalDisp_eachMPID, MarginalUnitReserve, AvailablePower : ", MarginalUnit.totalDisp_eachMPID, MarginalUnitReserve, MarginalUnit.availablePower
						# raw_input()
						print "Update swing Bus .... "
						desiredSwingBus = assignSwingBus(MarginalUnit, LFMPID)
						Solve()
						
						mpidNetflow = determineMPID_netFlow(MPID)
						deltaNetFlow = mpidNetflow - targetMpidNetFlow
						print "Updated NTG : ", deltaNetFlow
						# raw_input("======= Saved - Changed Swing Bus =======")
						############ Fine tuning......Making Working MPID NTG zero ############
						print "===== Fine tuning ..... Making Working MPID NTG to zero ======= "
						while abs(deltaNetFlow) > flowTolerance:
							if deltaNetFlow > 0:
								# raw_input("Reduce LF gen")
								print ("Reduce LF gen")
								UpdateWorkingLFMPID(abs(deltaNetFlow), MPID, "Reduce")  
							elif deltaNetFlow < 0:
								print ("Increase LF gen")
								UpdateWorkingLFMPID(abs(deltaNetFlow), MPID, "Increase")
								# break
							Solve()
							# mpidGen, mpidGen_pmax = determineMPID_Gen(MPID)
							mpidNetflow = determineMPID_netFlow(MPID)
							deltaNetFlow = mpidNetflow - targetMpidNetFlow
							print "deltaNetFlow : ", deltaNetFlow
							# raw_input()
						
						marginalUnitMismatch = checkMarginalUnit_Mismatch(MarginalUnit)
						print "marginalUnitMismatch : ", marginalUnitMismatch
						# raw_input("-------------------")
						############### Fine tuning Marginal Unit Mismatch ################
						############## MU mismatch should be inside tolerance level###
						marginalUnitMismatch, MarginalUnit = fineTuneMU_System(marginalUnitMismatch, MarginalUnit, MarginalUnitReserve, LFMPID)
						# raw_input()
						savedOWSP, savedOESP, newWATL, newEATL = hvdcDispatch()
						Solve()
						# raw_input("=============")
						marginalUnitMismatch = checkMarginalUnit_Mismatch(MarginalUnit)
						print "marginalUnitMismatch : ", marginalUnitMismatch
						marginalUnitMismatch, MarginalUnit = fineTuneMU_System(marginalUnitMismatch, MarginalUnit, MarginalUnitReserve, LFMPID)
					# finalmpidNetFlow = round(mpidNetflow, 4)
					
					
					# raw_input("========================HOLD ON====================")
					# sys.exit()
					
					# marginalUnitMismatch, MarginalUnit, desiredSwingBus = fineTuneMU_System(marginalUnitMismatch, MarginalUnit)
					# raw_input()
					
					
					final_marginalUnitMismatch = marginalUnitMismatch
					finalmpidNetFlow = 0
					finalMU = MarginalUnit
					# finalMUName = finalMU.assetName + " - " + str(int(finalMU.serial))
					finalMUName = finalMU.assetName + " - " + str(int(finalMU.blockNumber))
				
				######################### Save the State-2 case ######
				#############################################################
				# hvdcDispatch()
				
				############ Saving Final Case ############
				caseName = os.path.basename(self.topologyCase)
				outputCaseName = caseName.split(".sav")[0] + "_" + MPID.mpidName + ".sav"
				outputCaseName = os.path.join(self.hourly_output_dir, outputCaseName)
				print outputCaseName
				psspy.save(outputCaseName)
				
				# sys.exit()
				
				
				solutionStatus = checkSolution()
				finalmpidNetFlow = determineMPID_netFlow(MPID)
				deltaNetFlow = initialmpidNetFlow - finalmpidNetFlow
				final_watl = setHvdcDispatch_state2.getWATL_Dispatch()
				final_eatl = setHvdcDispatch_state2.getEATL_Dispatch()
				####### Iteration Limit Check
				# raw_input("Saved Case -------------------")
					
					################################
					
				# initMUName = initialMarginalUnit.assetName + " - " + str(int(initialMarginalUnit.serial))
				psspy.progress("\n\n===================================== Results ==============================================\n")
				print " Initial Load + Loss ", (initialLoad.real + initialLoss.real + initialShuntLoss.real)
				print "Initial Gen : ", initialGen.real 
				print "Initial Loss :" , (initialLoss.real + initialShuntLoss.real)
				
				#### Final Load, Loss Calculation ################
				################################
				FinalLoad, FinalGen, FinalLoss, FinalShuntLoss = self.GetSystemTotals(True)
				print " Final Load + Loss ", (FinalLoad.real + FinalLoss.real + FinalShuntLoss.real)
				print "Final Gen : ", FinalGen.real 
				print "Final Loss :" , (FinalLoss.real + FinalShuntLoss.real)
				# initialmpidNetFlow = round(initialmpidNetFlow, 4)
				
				loss_final = (FinalLoss.real + FinalShuntLoss.real)
				final_totalMPIDLoss = determine_mpidInternalLoss(self.MPIDs)
				netloss_final = loss_final - final_totalMPIDLoss
				print ("================================================================")
				
				
				if deltaNetFlow != 0:
					ilf = (netloss_init - netloss_final)/deltaNetFlow
				else:
					ilf = "N/A"
				print "ILF = ", ilf
				# # # Header = "MPID Name, Initial Net Flow (A), Initial System Loss (B), MPID Internal Loss (C), Net Inital system Loss (B-C), Marginal Unit, Final Net Flow (D), Total System Loss (E), MPID Internal Loss (F), Net system Loss (E-F), Marginal Unit, Loss Factor, MU Mismatch"
				state1_data = [MPID.mpidName, initialmpidNetFlow, loss_init, initial_totalMPIDLoss, netloss_init, initMUName, self.s1OWSP, self.s1OESP, init_watl, init_eatl]
				state2_data = [finalmpidNetFlow, loss_final, final_totalMPIDLoss, netloss_final, finalMUName, savedOWSP, savedOESP, final_watl, final_eatl, ilf, final_marginalUnitMismatch]
				comment = ["State-2 Successful", solutionStatus]
				data = state1_data + state2_data + comment
				data2 = [deltaNetFlow, netloss_init, netloss_final, initMUName, finalMUName]
			except:
				print "====ERROR=========="
				state1_data = [MPID.mpidName, initialmpidNetFlow, loss_init, initial_totalMPIDLoss, netloss_init, initMUName, self.s1OWSP, self.s1OESP, init_watl, init_eatl]
				[finalmpidNetFlow, loss_final, final_totalMPIDLoss, netloss_final, finalMUName, savedOWSP, savedOESP, final_watl, final_eatl, ilf, final_marginalUnitMismatch] = ["-", "-", "-", "-", "-", "-", "-", "-", "-", "Error", "-", ]
				state2_data = [finalmpidNetFlow, loss_final, final_totalMPIDLoss, netloss_final, finalMUName, savedOWSP, savedOESP, final_watl, final_eatl, ilf, final_marginalUnitMismatch]
				comment = ["Error in State-2", ""]
				data = state1_data + state2_data + comment
				deltaNetFlow = initialmpidNetFlow ######## finalmpidNetFlow could not be calculated!!!
				# data2 = [deltaNetFlow, netloss_init, "ERROR", initMUName, "ERROR"]	
				netloss_final = "ERROR"
				finalMUName = "ERROR"
				data2 = [deltaNetFlow, netloss_init, netloss_final, initMUName, finalMUName]
			
		else:
			state1_data = [MPID.mpidName, initialmpidNetFlow, loss_init, initial_totalMPIDLoss, netloss_init, initMUName, self.s1OWSP, self.s1OESP, init_watl, init_eatl]
			[finalmpidNetFlow, loss_final, final_totalMPIDLoss, netloss_final, finalMUName, savedOWSP, savedOESP, final_eatl, final_watl, ilf, final_marginalUnitMismatch] = ["-", "-", "-", "-", "-", "-", "-", "-", "-", "N/A", "-"]
			state2_data = [finalmpidNetFlow, loss_final, final_totalMPIDLoss, netloss_final, finalMUName, savedOWSP, savedOESP, final_eatl, final_watl, ilf, final_marginalUnitMismatch]
			comment = ["NTG < 1 MW", ""]
			data = state1_data + state2_data + comment
			[deltaNetFlow, netloss_init, netloss_final, initMUName, finalMUName] = ["", netloss_init, "", initMUName, ""]
			data2 = [deltaNetFlow, netloss_init, netloss_final, initMUName, finalMUName]
			###################### Check data2 formart with AUH #######
			###################
		

		
		return data, data2

			
def determine_mpidInternalLoss(MPIDs):
	
	totalMPIDLosses = 0
	for MPID in MPIDs:
		initmpidInternalLoss = 0
		mpidsubsystem = MPID.MPID_buses
		# mpidsubsystem.append(MPID.interfaceBus)
		# print mpidsubsystem
		if mpidsubsystem != []:
			sid = psspy.bsys(0,0,[ 0.4, 500.],0,[],len(mpidsubsystem),mpidsubsystem,0,[],0,[])
			ties = 1   ######## For each end of interior subsystem buses only
			flag = 2
			busesFrom, busesTo, statuses, ids, pflows, plosses = FindAllFlowData(sid, ties, flag)
			totalLoss = 0
			if busesFrom != [] and busesTo != [] and ids != []:
				for (frombus, tobus, id, status, pflow, ploss) in zip(busesFrom, busesTo, ids, statuses, pflows, plosses):
					# print frombus, tobus, id, status, pflow, ploss
					totalLoss += ploss
					initmpidInternalLoss = (totalLoss/2)
			else:
				initmpidInternalLoss = 0
		else:
			initmpidInternalLoss = 0
		totalMPIDLosses += initmpidInternalLoss
	return totalMPIDLosses
		
		
class MPID(object):  ## Updated by SDR
    def __init__(self, mpidName, loadmpid, tag, ISDtag, generators, loads, interfaceBus, MPID_buses, netFlow ):
		self.mpidName = mpidName
		self.loadmpid = loadmpid
		self.tag = tag
		self.ISDtag = ISDtag
		self.generators = generators
		self.loads = loads
		self.interfaceBus = interfaceBus
		self.MPID_buses = MPID_buses
		self.netFlow = netFlow

class loadObject(object):
	def __init__(self, bus, id):
		self.bus = bus
		self.id = id
		# self.pload = pload
		# self.qload = qload

class generatorObject(object):
	def __init__(self, bus, id):
		self.bus = bus
		self.id = id
		# self.pgen = pgen
		# self.pmax = pmax
		# self.pmin = pmin
		# self.qmax = qmax
		# self.qmin = qmin
		# self.mbase = mbase


def findSwingBus():
	err, [buses, types] = psspy.abusint(-1, 1, ("NUMBER", "TYPE"))
	for bus, type in zip(buses, types):
		if type == 3:
			return bus
			# print "Prev. Swing Bus - ", bus
			# psspy.bus_chng_3(bus, (2, ))
			break

def UpdateGen(bus, id, pgen, status):
	# print "Gen Dispatch Updates: ", bus, id, pgen, status
	if pgen == 0:
		status = 0
	else:
		status = 1
	err = psspy.machine_chng_2(bus, id, (status,_i,_i,_i,_i,_i), (pgen, ))
	swingBus = findSwingBus()
	busType = _i
	
	if bus == swingBus:	
		busType == 3
		psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	else:
		if status == 1:
			busType = 2
			psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
		else:
			busType = _i
			psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	print "Gen Dispatch Updates: ", bus, id, pgen, "status : ", status, "Bus Type :", busType
	# psspy.save("saved_case.sav")
	
def UpdateGen_Max(bus, id, pgen, pmax, status):
	if pgen == 0:
		status = 0
	else:
		status = 1
	err = psspy.machine_chng_2(bus, id, (status,_i,_i,_i,_i,_i), (pgen,_f,_f,_f,pmax, ))
	swingBus = findSwingBus()
	busType = _i
	if bus == swingBus:	
		busType == 3
		psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	else:
		if status == 1:
			busType = 2
			psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
		else:
			busType = _i
			psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	print "Gen Dispatch Updates: ", bus, id, pgen, "status : ", status, "Bus Type :", busType
			
			
			
def UpdateLF_Gen(bus, id, pgen, status):
	# print "Gen Dispatch Updates: ", bus, id, pgen, status
	if pgen == 0:
		status = 0
		err = psspy.machine_chng_2(bus, id, (_i,_i,_i,_i,_i,_i), (pgen, ))
	else:
		status = 1
		err = psspy.machine_chng_2(bus, id, (status,_i,_i,_i,_i,_i), (pgen, ))
	swingBus = findSwingBus()
	busType = _i
	
	if bus == swingBus:	
		busType == 3
		psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	else:
		if status == 1:
			busType = 2
			psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
		else:
			busType = _i
			psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	print "Gen Dispatch Updates: ", bus, id, pgen, "status : ", status, "Bus Type :", busType
	# psspy.save("saved_case.sav")
	
def UpdateLF_Gen_Max(bus, id, pgen, pmax, status):
	if pgen == 0:
		err = psspy.machine_chng_2(bus, id, (_i,_i,_i,_i,_i,_i), (pgen,_f,_f,_f,pmax, ))
	else:
		status = 1
		err = psspy.machine_chng_2(bus, id, (status,_i,_i,_i,_i,_i), (pgen,_f,_f,_f,pmax, ))
	swingBus = findSwingBus()
	busType = _i
	if bus == swingBus:	
		busType == 3
		psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	else:
		if status == 1:
			busType = 2
			psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
		else:
			busType = _i
			psspy.bus_chng_3(bus,[busType,_i,_i,_i],[_f,_f,_f,_f,_f,_f,_f],_s)
	print "Gen Dispatch Updates: ", bus, id, pgen, "status : ", status, "Bus Type :", busType
	# temp_sum += pgen
	# print temp_sum
			
#################### ----- MPIDs from excel sheet are stored in MPIDs -----------------------
## MPIDs [mpid  bus generators]
def CreateMPIDs__(excelFile): ## Updated by SDR
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name('Gen MPID Mapping (New)') ## Updated
	MPIDs = []
	for row in range(1, ws.nrows):
		tag = ws.cell(row, 2).value   ### Clumn C
		if tag == 'LF MPID' or tag == 'LF MPID-SKIP':
		
			mpidName = str(ws.cell(row, 1).value)   ### Clumn B
			loadmpid  = str(ws.cell(row, col2num("E")).value)   ### Clumn B
			
			
			ISDtag = ws.cell(row, 5).value   ### Clumn C
			associatedGens = [str(ws.cell(row, col).value) for col in range(6, 17)]
			associatedLoads = [str(ws.cell(row, col).value) for col in range(17, 20)]
			interfaceBus = (ws.cell(row, 20).value)
			if interfaceBus != '':
				interfaceBus = int(interfaceBus)
			
			mpid_subsystem = str((ws.cell(row, 21).value))
			buses = mpid_subsystem.split(",")
			netFlow = str((ws.cell(row, 23).value))
			# print 
			# print mpidName, tag, ISDtag
			# print associatedGens
			# print associatedLoads 
			# print interfaceBus
			# print buses
			# print netFlow 
			# raw_input()
			
			generators = []
			# if associatedGens != []:
			for gen in associatedGens:
				if gen != '':
					[bus, id] = gen.split("-")
					bus = int(bus)
					generators.append(generatorObject(bus, str(id)))
			
			loads = []
			# if associatedLoads != []:
			for load in associatedLoads:
				if load != '':
					[bus, id] = load.split("-")
					bus = int(bus)
					loads.append(loadObject(bus, id))
					
			MPID_buses = []
			for bus in buses:
				if bus != '':
					MPID_buses.append(int(bus.strip(" ")))
			if interfaceBus != '':
				MPID_buses.append(interfaceBus)
			# print mpidName, tag, ISDtag
			# print associatedGens
			# print associatedLoads 
			# print interfaceBus
			# print MPID_buses
			# print netFlow 
			# raw_input()
			temp = MPID(mpidName, loadmpid, tag, ISDtag, generators, loads, interfaceBus, MPID_buses, netFlow )
			MPIDs.append(temp)
	# sys.exit()    

	return MPIDs 
	

###################### Merit Order ###################
class meritorderData(object):  ## Updated by SDR
	def __init__(self, serial, assetName, Import_Export, blockNumber, flexibility, offerPrice, blockSize, availablePower, dispatchedPower, capabilityMW, totalDisp_eachMPID):
		self.serial = serial
		self.assetName = assetName
		self.Import_Export = Import_Export
		self.blockNumber = blockNumber
		self.flexibility = flexibility
		self.offerPrice = offerPrice
		self.blockSize = blockSize
		self.availablePower = availablePower
		self.dispatchedPower = dispatchedPower
		self.capabilityMW = capabilityMW
		self.totalDisp_eachMPID = totalDisp_eachMPID

def createMOList(excelFile): ## Updated by SDR
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name('EMMO_Dec01_HH1400')
	MOList = []
	for row in range(1, ws.nrows):
		# print "VAL :", col2num('A')
		assetName = str(ws.cell(row, col2num('E')).value)
		#### here assetName means MPID Name in Mapping File
		# print assetName
		# raw_input()
		if assetName != 'N/A':
			serial = ws.cell(row, col2num('C')).value
			Import_Export = ws.cell(row, col2num('F')).value
			blockNumber = ws.cell(row, col2num('G')).value
			flexibility = ws.cell(row, col2num('H')).value
			offerPrice = ws.cell(row, col2num('I')).value 
			blockSize = ws.cell(row, col2num('J')).value
			availablePower = ws.cell(row, col2num('K')).value
			dispatchedPower = ws.cell(row, col2num('L')).value
			capabilityMW = ws.cell(row, col2num('M')).value
			totalDisp_eachMPID = ws.cell(row, col2num('N')).value
			
			
			# print serial
			# print assetName
			# print Import_Export
			# print blockNumber
			# print flexibility
			# print offerPrice
			# print blockSize
			# print availablePower
			# print dispatchedPower
			# print capabilityMW
			# print totalDisp_eachMPID
			# raw_input()

			MOList.append(meritorderData(serial, assetName, Import_Export, blockNumber, flexibility, offerPrice, blockSize, availablePower, dispatchedPower, capabilityMW, totalDisp_eachMPID))
	return MOList
	
############## Determining Gen Data
def FindAllMachineData(sid = -1, flag = 4):  ## ## Updated by SDR
	# sid = -1  ### by Default
	# flag = 4 ### for All machines
	err, [buses, statuses] = psspy.amachint(sid, flag, ("NUMBER", "STATUS"))
	err, [ids] = psspy.amachchar(sid, flag, ("ID",))
	err, [pgens, pmaxes, pmins, qmaxes, qmins, mbases] = psspy.amachreal(sid, flag, ("PGEN", "PMAX", "PMIN", "QMAX", "QMIN", "MBASE"))
	
	
	
	return buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases

def GetGenData(getbus, getid): ## Updated by SDR
	# print "---", getbus, getid
	buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases = FindAllMachineData(sid = -1, flag = 4)
	# print ids
	
	# raw_input()
	for (bus, id, status, pgen, pmax, pmin, qmax, qmin, mbase) in zip(buses, ids, statuses, pgens, pmaxes, pmins, qmaxes, qmins, mbases):
		# print bus, id 
		if bus == getbus and id.strip(" ") == getid:
			# if id == '3':
			# print "FOUND"
			
			return status, pgen, pmax, pmin, qmax, qmin, mbase
	# raw_input("-------")
	print "Generator Not Found"
	raise ValueError
			
	# return status, pgen, pmax, pmin, qmax, qmin, mbase

	

	
def determineMPID_Gen(MPID):
	# print MPID.mpidName
	totalPgen = 0
	totalPmax = 0
	if MPID.mpidName == 'BCHIMP':
		totalPgen = TieMeasure()
		totalPmax = totalPgen
	elif MPID.mpidName == 'SPCIMP':
		for load in MPID.loads:
			status, pload, qload = getLoadData(load.bus, load.id)
			totalgen = 0
			if MPID.generators != '':
				for gen in MPID.generators:
					status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
					if status != 0:
						totalgen += pgen
					totalPmax += pmax
			totalPgen = totalgen - pload
	else:
		if MPID.generators != '':
			for gen in MPID.generators:
				status, pgen, pmax, pmin, qmax, qmin, mbase = GetGenData(gen.bus, gen.id)
				if status != 0:
					totalPgen += pgen
				totalPmax += pmax
	print totalPgen, totalPmax
	return totalPgen, totalPmax
############### Find Bus Data




############### Determining Load Data ###
def FindAllLoadData(sid = -1, flag = 4):
	err, [buses, statuses] = psspy.aloadint(sid, flag, ("NUMBER", "STATUS"))
	err, [ids] = psspy.aloadchar(sid, flag, ("ID", ))
	err, [loads] = psspy.aloadcplx(sid, flag, ("TOTALACT", ))
	return buses, ids, statuses, loads
	
def getLoadData(loadbus, loadid):
	buses, ids, statuses, loads = FindAllLoadData()
	# print buses, ids, statuses, loads
	# raw_input()
	# print ids
	for bus, id, status, load in zip(buses, ids, statuses, loads):
		# print bus, id
		# raw_input()
		if bus == loadbus and id.strip(" ") == loadid:
			# print bus , id, status, load.real
			# raw_input()
			return status, load.real, load.imag
			# return 0, 0, 0
	return 0, 0, 0

def UpdateLoad(loadbus, loadid, status, p, q):
	err = psspy.load_chng_4(loadbus, loadid, [status, _i,_i,_i,_i,_i], [p, q, _f, _f,_f,_f])
	
	
	
	
def determineMPID_Load(MPID):
	totalPload = 0
	totalQload = 0
	if MPID.loads != []:
		for load in MPID.loads:
			print "BUS_ID", load.bus, load.id
			# raw_input()
			status, pload, qload = getLoadData(load.bus, load.id)
			# print status, pload, qload
			
			if status != 0:
				totalPload += pload 
				totalQload += qload
	
	print totalPload, totalQload
	# raw_input("-----Load-----")
	return totalPload, totalQload

###### Determining MPID Net Flow
def FindAllFlowData(sid = -1, ties = 1, flag = 2):
	err, [busesFrom, busesTo, statuses] = psspy.aflowint(sid, 1, ties, flag, ("FROMNUMBER", "TONUMBER", "STATUS"))
	err, [ids] = psspy.aflowchar(sid, 1, ties, flag, ("ID",))
	err, [pflows, plosses] = psspy.aflowreal(sid, 1, ties, flag, ("P", "PLOSS"))
	
	return busesFrom, busesTo, statuses, ids, pflows, plosses

def getBranchFlow(fromBus, toBus, ID, direction="positive"):
	busesFrom, busesTo, statuses, ids, pflows, plosses = FindAllFlowData()
	for (busFrom, busTo, status, id, pflow, ploss) in zip(busesFrom, busesTo, statuses, ids, pflows, plosses):
		temp = []
		# if busFrom == fromBus and busTo == toBus:
		if busFrom == fromBus and busTo == toBus and id.strip(" ") == ID:
			# temp.append(id)
			# temp.append(ID)
			# print temp
			# raw_input()
		
			if direction == "positive":
				print status, pflow, ploss
				# raw_input()
				return  status, pflow, ploss
			else:
				print status, pflow, ploss
				# raw_input()
				return  status, -pflow, ploss
	
	print "Branch Not Found"
	raise ValueError
	
def determineMPID_netFlow(MPID):
	print "\n========================= Determining NTG of MPID - ", MPID.mpidName, " ==========================\n" 
	print MPID.netFlow
	# raw_input()
	# MPID.netFlow = MPID.netFlow.upper()
	if MPID.netFlow != '':
		if MPID.mpidName == 'BCHIMP':
			totalFlow = TieMeasure()
		elif MPID.mpidName == 'SPCIMP':
			mpidLoad, mpidQ = determineMPID_Load(MPID)
			totalFlow = -mpidLoad
		else:
			if MPID.ISDtag == "DOS":
				mpidLoad, mpidQ = determineMPID_Load(MPID)
				totalFlow = mpidLoad
			else:
				totalFlow = 0
				if MPID.netFlow == "GEN-LOAD":
					totalPload, totalQload = determineMPID_Load(MPID)
					totalPgen, totalPmax = determineMPID_Gen(MPID)
					totalFlow = totalPgen - totalPload
				else:
					netFlowdef_temp = MPID.netFlow
					netFlowdef = netFlowdef_temp.split(",")
					print netFlowdef
					branches = []
					
					for text in netFlowdef:
						branches.append(text.strip(" "))
					print branches
					for branch in branches:
						print "branch :  ", branch 
						if ("-(" in branch) and ("DL" not in branch):
							temp = branch.split("-(")
							# print temp
							temp = temp[1].strip(")")
							# print temp
							[fromBus, toBus, id] = temp.split("-")
							print [fromBus, toBus, id]
							# raw_input()
							[status, flow, loss] = getBranchFlow(int(fromBus), int(toBus), id, "negative")
						elif ("(" in branch) and ("DL" not in branch):
							temp = branch.split("(")
							# print temp
							temp = temp[1].strip(")")
							# print temp
							[fromBus, toBus, id] = temp.split("-")
							print [fromBus, toBus, id]
							# raw_input()
							[status, flow, loss] = getBranchFlow(int(fromBus), int(toBus), id, "positive")
						elif "LOAD" in branch:
							pload, qload = determineMPID_Load(MPID)
							if "-" in branch:
								flow = -pload
							else:
								flow = pload
						elif "DL" in branch:
							temp = branch.split("(")
							temp = temp[1].strip(")")
							[loadbus, loadid] = temp.split("-")
							loadid = str(loadid)
							loadbus = int(loadbus)
							print loadid
							# raw_input()
							status, pload, qload = getLoadData(loadbus, loadid)
							print loadbus, loadid, status, pload, qload
							if "-DL" in branch:
								flow = -pload
							else:
								flow = pload
						else:
							[fromBus, toBus, id] = branch.split("-")
							[status, flow, loss] = getBranchFlow(int(fromBus), int(toBus), id, "positive")
						print "Flow :", flow
						# totalFlow = totalFlow + flow[1]
						totalFlow = totalFlow + flow
						# print totalFlow
						# raw_input()
	else:
		raise
	print "totalFlow : ", totalFlow
	print "================================================"
	# raw_input()
	return totalFlow
	


def remove_duplicates(values):
    output = []
    seen = set()
    for value in values:
        # If value has not been encountered yet,
        # ... add it to both list and set.
        if value not in seen:
            output.append(value)
            seen.add(value)
    return output
	
def findDates(caseFiles):
	
	dates = dict()
	date_months = []
	
	for caseFile in caseFiles:
		# print caseFile
		caseName = os.path.basename(caseFile)
		tempName = caseName.split(".sav")[0]
		tempName = tempName.split("_")
		
		day = tempName[0]
		month = tempName[1].upper()
		year = tempName[2]
		hour = tempName[4]
		
		date = year + "-" + month + "-" + day + "-" + hour + "-" + "00"
		# print date
		dates[caseName] = date
		date_months.append(month)
		
		# raw_input()
	
	months = remove_duplicates(date_months)
	# print months
	# sys.exit()
	return dates, months

	
#####################
#############################
def selectMonthlyMPIDMapping(GenMappingFiles, month):
	desiredFile = ''
	for excelFile in GenMappingFiles:
		if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			desiredFile = excelFile
	return desiredFile	


def CreateMPIDs(excelFile, month): ## Updated by SDR
	
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name('Gen MPID Mapping') ## Updated
	MPIDs = []
	for row in range(1, ws.nrows):
		tag = ws.cell(row, 2).value   ### Clumn C
		# if tag == 'LF MPID' or tag == 'LF MPID-SKIP' or tag == 'SKIP':
		if tag == 'LF MPID' or tag == 'LF MPID-SKIP':
			mpidName = str(ws.cell(row, col2num("B")).value)   ### Clumn B
			loadmpid  = str(ws.cell(row, col2num("E")).value)   ### Clumn B
			ISDtag = ws.cell(row, col2num("F")).value   ### Clumn C
			associatedGens = [str(ws.cell(row, col).value) for col in range(6, 17)]
			associatedLoads = [str(ws.cell(row, col).value) for col in range(17, 20)]
			interfaceBus = (ws.cell(row, col2num("V")).value)
			if interfaceBus != '':
				interfaceBus = int(interfaceBus)
			mpid_subsystem = str((ws.cell(row, col2num("W")).value))
			buses = mpid_subsystem.split(",")
			netFlow = str((ws.cell(row, col2num("Y")).value)).upper()
			# print 
			# print mpidName, tag, ISDtag
			# print associatedGens
			# print associatedLoads 
			# print interfaceBus
			# print buses
			# print netFlow 
			# raw_input()
			
			generators = []
			# if associatedGens != []:
			for gen in associatedGens:
				if gen != '':
					[bus, id] = gen.split("-")
					bus = int(bus)
					generators.append(generatorObject(bus, str(id)))
			
			loads = []
			# if associatedLoads != []:
			for load in associatedLoads:
				if load != '':
					[bus, id] = load.split("-")
					bus = int(bus)
					loads.append(loadObject(bus, id))
					
			MPID_buses = []
			for bus in buses:
				if bus != '':
					MPID_buses.append(int(bus.strip(" ")))
			if interfaceBus != '':
				MPID_buses.append(interfaceBus)
			# print mpidName, tag, ISDtag
			# print associatedGens
			# print associatedLoads 
			# print interfaceBus
			# print MPID_buses
			# print netFlow 
			# raw_input()
			temp = MPID(mpidName, loadmpid, tag, ISDtag, generators, loads, interfaceBus, MPID_buses, netFlow )
			MPIDs.append(temp)
	# sys.exit()    
			
	return MPIDs 
	
###################################################
#####################################
###########
def selectMonthlyCase(caseFiles, month):
	desiredMonthlyCase = ''
	for caseFile in caseFiles:
		if month.lower() in os.path.splitext(os.path.split(caseFile)[1])[0].lower():
			desiredMonthlyCase = caseFile
			
	return desiredMonthlyCase	


########################################################
####################################################
def SelectMonthlyLoadMapping(loadMappingFiles, month):
	desiredFile = ''
	for excelFile in loadMappingFiles:
		if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			desiredFile = excelFile
			
	return desiredFile
class loadmapdata(object):
	def __init__(self, genMPID, loadMPID, bus, id, isdtag):
		self.genMPID = genMPID
		self.loadMPID = loadMPID
		self.bus = bus
		self.id = id
		self.isdtag = isdtag
def readLoadMapping(excelFile):
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name("Load Mapping")
	loadMappingList = []
	for row in range(1, ws.nrows):
		genMPID = str(ws.cell(row, 0).value)
		loadMPID = str(ws.cell(row, 1).value)
		# print assetName
		# raw_input()
		if loadMPID != '':
			
			bus = int(ws.cell(row, 2).value)
			id = (ws.cell(row, 4).value)
			# print id, type(id)
			if type(id) is  float:
				id = str(int(id))
			elif type(id) is  int:
				id = str(id)
			else: ## type(id) is  unicode:
				id = str(id)
			isdtag = (ws.cell(row, col2num("S")).value)
			# print loadMPID, bus, id
			# raw_input()
			loadMappingList.append(loadmapdata(genMPID, loadMPID, bus, id, isdtag))
	# raw_input()
	return loadMappingList
######################################
####################################
		


################################################
################################################
###################


#############################
#############################
class meritorderData(object):  ## Updated by SDR
	def __init__(self, time, serial, assetName, Import_Export, blockNumber, flexibility, offerPrice, blockSize, availablePower, dispatchedPower, capabilityMW, totalDisp_eachMPID):
		self.time = time
		self.serial = serial
		self.assetName = assetName
		self.Import_Export = Import_Export
		self.blockNumber = blockNumber
		self.flexibility = flexibility
		self.offerPrice = offerPrice
		self.blockSize = blockSize
		self.availablePower = availablePower
		self.dispatchedPower = dispatchedPower
		self.capabilityMW = capabilityMW
		self.totalDisp_eachMPID = totalDisp_eachMPID

class emmocorrection(object):
	def __init__(self, time, assetName, blockNumber, availablePower, totalDisp_eachMPID):
		self.time = time
		self.assetName = assetName
		self.blockNumber = blockNumber
		self.availablePower = availablePower
		self.totalDisp_eachMPID = totalDisp_eachMPID
	
	
	
	
def SelectMonthlyEMMO(EMMOFiles, month):
	desiredFile = ''
	for excelFile in EMMOFiles:
		if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			desiredFile = excelFile
			
	return desiredFile
	
# def createHourlyEMMO(monthlyEMMO, time, monthlyEMMOcorrection):
def createHourlyEMMO(monthlyEMMO, time):
	currentHourEMMO = []
	serial = 0
	for row in monthlyEMMO:
		if row.time == time:
			currentHourEMMO.append(row)
			serial += 1
			row.serial = serial
	def determineMPIDTotalDispatch(currentHourEMMO):
		for row in currentHourEMMO:
			currentSerial = row.serial
			currentAssetName = row.assetName
			totalDispatch = 0
			for eachrow in currentHourEMMO:
				if eachrow.serial <= currentSerial and eachrow.assetName == currentAssetName:
					totalDispatch = totalDispatch + eachrow.availablePower
				
			row.totalDisp_eachMPID = totalDispatch
			
		return currentHourEMMO
	
	def correctEMMO(currentHourEMMO, time, monthlyEMMOcorrection):
		# print time
		# raw_input()
		for eachRecord in monthlyEMMOcorrection:
			# print eachRecord.time, time
			if eachRecord.time == time:
				for row in currentHourEMMO:
					# print row.assetName, eachRecord.assetName
					# print row.blockNumber, eachRecord.blockNumber
					if row.assetName == eachRecord.assetName and row.blockNumber == eachRecord.blockNumber:
						row.availablePower = eachRecord.availablePower
						row.totalDisp_eachMPID = eachRecord.totalDisp_eachMPID
						print time, row.assetName, row.blockNumber, row.availablePower, row.totalDisp_eachMPID
						# raw_input()
		# sys.exit()
		return currentHourEMMO
	currentHourEMMO = determineMPIDTotalDispatch(currentHourEMMO)
	# currentHourEMMO_corrected = correctEMMO(currentHourEMMO, time, monthlyEMMOcorrection)
			
	# return currentHourEMMO_corrected
	return currentHourEMMO
			
def readMonthlyEMMO(excelFile): ## Updated by SDR
	wb = xlrd.open_workbook(excelFile)
	sheetName = "EMMO"
	ws = wb.sheet_by_name(sheetName)
	monthlyEMMOList = []
	for row in range(1, ws.nrows):
		# print "VAL :", col2num('A')
		assetName = str(ws.cell(row, col2num('E')).value)
		#### here assetName means MPID Name in Mapping File
		# print assetName
		# raw_input()
		if assetName != 'N/A':
			time = ws.cell(row, col2num('B')).value
			# # t1 = time.split(":")[0]
			# # t2 = time.split(":")[1]
			# # t3 = time.split(":")[2]
			# # t4 = time.split(":")[3]
			
			# # t2 = str(int(t2) + 1)
			# # t2 = t2.zfill(2)
			
			# # time = t1 + ":" + t2 + ":" + t3 +":" + t4
			# serial = ws.cell(row, col2num('C')).value
			serial = ''
			Import_Export = ws.cell(row, col2num('F')).value
			blockNumber = int(ws.cell(row, col2num('G')).value)
			flexibility = ws.cell(row, col2num('H')).value
			offerPrice = ws.cell(row, col2num('I')).value 
			blockSize = ws.cell(row, col2num('J')).value
			availablePower = ws.cell(row, col2num('K')).value
			dispatchedPower = ws.cell(row, col2num('L')).value
			capabilityMW = ws.cell(row, col2num('M')).value
			# totalDisp_eachMPID = ws.cell(row, col2num('N')).value
			totalDisp_eachMPID = 0
			
			monthlyEMMOList.append(meritorderData(time, serial, assetName, Import_Export, blockNumber, flexibility, offerPrice, blockSize, availablePower, dispatchedPower, capabilityMW, totalDisp_eachMPID))
	return monthlyEMMOList

def readMonthlyEMMOcorrection(EMMOcorrectionFile):
	wb = openpyxl.load_workbook(EMMOcorrectionFile, data_only = True)
	ws = wb.get_sheet_by_name("Update EMMO")
	emmocorrectionList = []
	for row in range(2, ws.max_row+1):
		time = ws["A" + str(row)].value
		assetName = ws["B" + str(row)].value
		blockNumber = ws["C" + str(row)].value
		availablePower = ws["D" + str(row)].value
		totalDisp_eachMPID = ws["E" + str(row)].value
		emmocorrectionList.append(emmocorrection(time, assetName, blockNumber, availablePower, totalDisp_eachMPID))
	return emmocorrectionList
	######################################
#######################################
def SelectMonthlyLoad(loadDataFiles, month):
	desiredFile = ''
	for excelFile in loadDataFiles:
		if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			desiredFile = excelFile
			
	return desiredFile

class loadData(object):  ## Updated by SDR
	def __init__(self, mpidName, mwData):
		self.mpidName = mpidName
		self.mwData = mwData
	
def readMonthlyLoad(excelFile):
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name("Load Data")
	monthlyLoadData = []
	
	times = []
	for col in range(col2num('B'), ws.ncols):
		date = (ws.cell(0, col).value)
		temp = xlrd.xldate.xldate_as_datetime(date, wb.datemode)
		dt = datetime.timedelta(hours=1)
		time = temp - dt
		time = time.strftime("%d%b%Y:%H:%M:%S")
		time = time.upper()
		print time
		# raw_input(time)
		# year = temp[0]
		# month = temp[1]
		# day = temp[2]
		
		# hour = str(ws.cell(2, col).value)
		# time = year+month+day+":"+hour
		times.append(time)
	# raw_input("END")
	for row in range(4, ws.nrows):
		mpidName = str(ws.cell(row, 0).value)
		mpidName = mpidName.replace('MP_', '')
		
		mwData = dict()
		# raw_input()
		if mpidName != '':
			for col in range(col2num('B'), ws.ncols):
				k = col2num('B')
				# print row, col, [col-k]
				# print times[col-k]
				mwData[times[col-k]] = ws.cell(row, col).value
			# print mpidName, mwData
			monthlyLoadData.append(loadData(mpidName, mwData))
	# raw_input()		
	return monthlyLoadData

def createHourlyLoad(monthlyLoad, time):
	currentHourLoad = []
	
	for row in monthlyLoad:
		mpidName = row.mpidName
		mwData = row.mwData[time]
		
		currentHourLoad.append(loadData(mpidName, mwData))
	
	return currentHourLoad
#############################################
###############################################

def SelectMonthlyTSS(tssDataFiles, month):
	desiredFile = ''
	for excelFile in tssDataFiles:
		if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			desiredFile = excelFile
			
	return desiredFile

class tssData(object):  ## Updated by SDR
	def __init__(self, mpidName, mwData):
		self.mpidName = mpidName
		self.mwData = mwData

def readMonthlyTSS(excelFile):
	wb = xlrd.open_workbook(excelFile)
	ws = wb.sheet_by_name("TSS")
	monthlyTSSData = []
	
	times = []
	for col in range(col2num('C'), ws.ncols):
	# for col in range(col2num('C'), col2num('AB')):
		date = str(ws.cell(0, col).value)
		if date != "":
			date = (ws.cell(0, col).value)
			temp = xlrd.xldate.xldate_as_datetime(date, wb.datemode)
			time = temp.strftime("%d%b%Y:%H:%M:%S")
			time = time.upper()
			
			# print time
			# hour = int(ws.cell(1, col).value)
			# hour = str(hour)
			# hour = hour.zfill(2)
			
			# print date, hour
			# raw_input()
			# # # hour = (ws.cell(1, col).value).strip(" ")
			# temp = date.split("-")
			# yr = temp[0]
			# month = temp[1]
			# day = temp[2]
			# dt = yr+"-"+month+"-"+day+"-"+hour
			
			
			# date_time = datetime.datetime.strptime(dt, "%Y-%m-%d-%H")
			# # temp = xlrd.xldate.xldate_as_datetime(date, wb.datemode)
			# time = date_time.strftime("%d%b%Y:%H:%M:%S")
			# time = time.upper()
			# print time
			# # raw_input(time)
			times.append(time)
	
	# raw_input("END-----")
	
	for row in range(2, ws.nrows):
		mpidName = str(ws.cell(row, 1).value)
		isdtag = str(ws.cell(row, 0).value)
		# mpidName = mpidName.replace('MP_', '')
		mwData = dict()
		if mpidName != '' and (isdtag == 'ISD' or isdtag == 'ISD-New'):
			for col in range(col2num('C'), ws.ncols):
				k = col2num('C')
				# print row, col, [col-k]
				# print mpidName, times[col-k], ws.cell(row, col).value
				mwData[times[col-k]] = ws.cell(row, col).value
			# print mpidName, mwData
				monthlyTSSData.append(tssData(mpidName, mwData))
	# raw_input()		
	return monthlyTSSData

def SelectMonthlyEMMOcorrection(emmoCorrectionFiles, month):
	desiredFile = ''
	for excelFile in emmoCorrectionFiles:
		if month.lower() in os.path.splitext(os.path.split(excelFile)[1])[0].lower():
			desiredFile = excelFile
			
	return desiredFile
	

def createHourlyTSS(monthlyTSS, time):
	currentHourLoad = []
	
	for row in monthlyTSS:
		mpidName = row.mpidName
		mwData = row.mwData[time]
		currentHourLoad.append(tssData(mpidName, mwData))
	
	return currentHourLoad


class munitObject(object):
	def __init__(self, filename, munit):
		self.filename = filename
		self.munit = munit


def readMULogfiles(logfiles):
	
	state1_munits = dict()
	state1_OWSP = dict()
	state1_OESP = dict()
	state1_watlFlow = dict()
	state1_eatlFlow = dict()
	for logfile in logfiles:
		
		with open(logfile) as f: 
			data = f.readlines() 
			
		for line in data:
			print line
			# raw_input()
			words = line.split()
			filename = words[0]
			munit = words[1]
			s1OWSP = words[2]
			s1OESP = words[3]
			s1watlFlow = words[4]
			s1eatlFlow = words[5]
				
			state1_munits[filename] = munit
			state1_OWSP[filename] = float(s1OWSP)
			state1_OESP[filename] = float(s1OESP)
			state1_watlFlow[filename] = float(s1watlFlow)
			state1_eatlFlow[filename] = float(s1eatlFlow)
	
	# print state1_munits
	return state1_munits, state1_OWSP, state1_OESP, state1_watlFlow, state1_eatlFlow 
			
		
	
	
	
################################
def ProcessCases(caseFiles, GenMappingFiles, EMMOFiles, outputWB, munitlogfiles, emmoCorrectionFiles=None):
	intertie = [[329, 819, '87'], [232, 1501, '86'], [456, 90000, '01']]
	
	##voltageLimits = ReadVoltageLimits(voltageFilename)
	wb = xlwt.Workbook()
	monthlyMPIDMapping = dict()
	# monthlyCases = dict()
	# monthlyLoadMapping = dict()
	monthlyEMMO = dict()
	monthlyEMMOcorrection = dict()
	# monthlyLoad = dict()
	# monthlyTSS = dict()
	timeNow = datetime.datetime.now()
	timeNow = timeNow.strftime("%d%b%Y-%H-%M")
	print "Simulation Start Time : ", timeNow
	
	errorlogfilename = os.path.join(os.getcwd(), "LossInfoProgram-Error-%s.log" %timeNow)
	errorlog = open(errorlogfilename, "w")
	errorlog.write("\tStart Time = %s\n" %timeNow)
	
	dates, months = findDates(caseFiles)
	# sys.exit()
	psspy.psseinit(100000)
	for month in months:
		logfilename = os.path.join(os.getcwd(), month+ "-%s.log" %timeNow)
		log_month = open(logfilename, "w")
		log_print(log_month)
		################ Monthly MPID Mapping ############
		GenMappingFile = selectMonthlyMPIDMapping(GenMappingFiles, month)
		monthlyMPIDMapping[month] = CreateMPIDs(GenMappingFile, month)
		################ Monthly Cases ############
		# monthlyCases[month] = selectMonthlyCase(caseFiles, month)
		#### Select EMMO ####
		EMMOFile = SelectMonthlyEMMO(EMMOFiles, month)
		monthlyEMMO[month] = readMonthlyEMMO(EMMOFile)
		# EMMOcorrectionFile = SelectMonthlyEMMOcorrection(emmoCorrectionFiles, month)
		# monthlyEMMOcorrection[month] = readMonthlyEMMOcorrection(EMMOcorrectionFile)
	# raw_input()
	# for date in dates:
	
	# wb_result = xlwt.Workbook()
	# ws1 = wb_result.add_sheet("NTG")
	# ws2 = wb_result.add_sheet("State-1 Loss")
	# ws3 = wb_result.add_sheet("State-2 Loss")
	# ws4 = wb_result.add_sheet("State-1 Marginal Unit")
	# ws5 = wb_result.add_sheet("State-2 Marginal Unit")
	
	# enable_print()
	# state1_munits = readMULogfiles(munitlogfiles)
	state1_munits, state1_OWSP, state1_OESP, state1_watlFlow, state1_eatlFlow = readMULogfiles(munitlogfiles)
	
	############### Output Directory
	outputDir = "State-2 - %s" %timeNow
	ensure_dir(outputDir)
	output = os.path.join(outputDir, "Final Result " + timeNow + ".xls")
	output_Final = os.path.join(outputDir, "Final LF Calculation - " + timeNow + ".xlsx")
	
	
	nextDate = 1
	nextrow = 0
	writeStart = 0
	newCase = 0
	
	outResults = dict()
	
	for caseFile in caseFiles:
		# print caseFile
		caseName = os.path.basename(caseFile)
		# print caseName
		# dates = ["2015-DEC-01-14-00", "2015-DEC-01-03-00"]
		# date = dt.strftime("%Y-%b-%d-%H-%M")
		date = dates[caseName]
		# print  date
		year = date.split("-")[0]
		month = date.split("-")[1].upper()
		day = date.split("-")[2]
		hour = date.split("-")[3]
		min = date.split("-")[4]
		
		dt = datetime.datetime.strptime(date, "%Y-%b-%d-%H-%M")
		date = dt.strftime("%Y/%m/%d %H:%M")
		enable_print()
		print "Working on : ... " ,date
		caseFilename = day+"_"+month+"_"+year+"_Hour_"+hour+".sav" 
		
		###### Create Output Directory ##########
		hourly_output_dirName = "Output_" + day+"_"+month+"_"+year+"_Hour_"+hour
		state2results_dir = os.path.join(outputDir, "State-2 Results")
		hourly_output_dir = os.path.join(outputDir, hourly_output_dirName)
		ensure_dir(hourly_output_dir)
		ensure_dir(state2results_dir)
		##################### Reports ########## Print files
		reportName = "Report_" + day+"_"+month+"_"+year+"_Hour_"+hour + ".log"
		reportfilename = os.path.join(hourly_output_dir, reportName)
		reportlog = open(reportfilename, "w")
		log_print(reportlog)
		
		
		year_2 = str(int(year)-2)
		time = day+month+year_2+":"+hour+":00:00"
		year_2_emmo = year_2.split('20')[1]
		time_emmo = day+month+year_2_emmo+":"+hour+":00:00"

		# currentHourEMMO = createHourlyEMMO(monthlyEMMO[month], time_emmo, monthlyEMMOcorrection[month])
		currentHourEMMO = createHourlyEMMO(monthlyEMMO[month], time_emmo)
		# currentHourTSS = createHourlyTSS(monthlyTSS[month], time)
		
		# caseFilename = monthlyCases[month]
		MPIDs = monthlyMPIDMapping[month]
		MOList = currentHourEMMO

		# raw_input()
		munit = state1_munits[caseName]
		s1OWSP = state1_OWSP[caseName] 
		s1OESP = state1_OESP[caseName]
		s1watlFlow = state1_watlFlow[caseName]
		s1eatlFlow = state1_eatlFlow[caseName]
		
		s1_hvdcParameters = [s1OWSP, s1OESP, s1watlFlow, s1eatlFlow]
		
		case = Case(caseFile, intertie, MPIDs, MOList, hourly_output_dir, month, munit, s1_hvdcParameters)
		
		# ############ Process State-2 and write results ######
		# #######################################################
		status = dict()
		
		results = dict()
		# # caseName = os.path.splitext(os.path.split(caseFilename)[1])[0].lower()
		# # print caseName
		# # sheetName = caseFilename.split(".sav")[0]
		
		outputResult = os.path.join(state2results_dir, caseName.split(".sav")[0] + ".xls")
		wb = xlwt.Workbook()
		ws = wb.add_sheet("Results")
		MPIDs = sorted(MPIDs, key=attrgetter('mpidName'), reverse = False)
		
		wantedMPIDs = ['0000004813', '0000003511']
		# wantedMPIDs = ['CMH1', '0000025611',]
		# wantedMPIDs = ['NPC1', 'BCHIMP', 'SPCIMP', 'MATLIMP']
		# wantedMPIDs = ['EGC1', '321S033', 'BCHIMP', 'SPCIMP', 'MATLIMP']

		# wantedMPIDs = ['Proj_1321',] 
		# wantedMPIDs = ['AKE1', 'SCR1', 'SCL1', 'NPC1'] 
		# wantedMPIDs = ['Proj_524', 'Proj_580', 'Proj_693', 'Proj_803'] 

		# wantedMPIDs = ['SCR1', 'SPCIMP', 'CNR5', 'MATLIMP', 'PR1', 'RL1', 'RYMD']
		newCase = 0
		for mpid in MPIDs:
			if mpid.tag == "LF MPID":
			# if mpid.mpidName in wantedMPIDs and mpid.tag == "LF MPID":
				if mpid.mpidName == "CES2":
					continue
				else:
					# enable_print()
					print " ============Processing MPID========== %s:" % mpid.mpidName 
					try:
						status[mpid.mpidName], results[mpid.mpidName] = case.ProcessMPID(mpid)
						writedata2 = results[mpid.mpidName]
						# status[mpid.mpidName] = [212, 212, 212, 212, 212]
						writedata = status[mpid.mpidName]
						# except:
							# writedata = [mpid.mpidName, "-","-","-","-","-","-","-","-","-","-",'ERROR','-']
							# writedata2 = ['ERROR','ERROR','ERROR']
						Write(outputResult, mpid.mpidName, writedata, wb, ws, newCase)
						newCase += 1
						# nextrow = writeFinal(output, mpid.mpidName, writedata2, wb_result, ws1, ws2, ws3, ws4, ws5, date, writeStart, nextrow, nextDate)
						writeStart += 1
						# raw_input()
					except:
						errorlog.write("\tError in Handling Case = %s for \nMPID%s\n" %(caseFile, mpid.mpidName))
						pass
		nextDate += 1
		nextrow = 0
		# raw_input()
		
		outResults[date] = results
	
	
	enable_print()
	# writeResults(outResults, outputWB, output_Final)
	
	timeNow = datetime.datetime.now()
	timeNow = timeNow.strftime("%d%b%Y-%H-%M")
	errorlog.write("\tStop Time = %s\n" %timeNow)
	errorlog.close()

	
	
class iterationLimitError(Exception):
	def __init__(self, mismatch, iterationNumber):
		self.iterationNumber = iterationNumber
		self.mismatch = mismatch

class solutionError(Exception):
	def __init__(self, solvedMsg):
		self.solvedMsg = solvedMsg

class HvdcError(Exception):
	def __init__(self):
		print "HVDC ERROR"
	
def roundTime(dt=None, roundTo=60):
   # """Round a datetime object to any time laps in seconds
   # dt : datetime.datetime object, default now.
   # roundTo : Closest number of seconds to round to, default 1 minute.
   # Author: Thierry Husson 2012 - Use it as you want but don't blame me.
   # """
	# if dt == None : 
		# dt = datetime.datetime.now()
	seconds = (dt.replace(tzinfo=None) - dt.min).seconds
	rounding = (seconds+roundTo/2) // roundTo * roundTo
		
	return dt + datetime.timedelta(0,rounding-seconds,-dt.microsecond)
   
 
def writeResults(outResults, outputWB, output_Final):
	# wb = xlrd.open_workbook(outputWB, formatting_info=True, on_demand=True)
	wb_readonly = openpyxl.load_workbook(outputWB, data_only = True)
	wb = openpyxl.load_workbook(outputWB, data_only = False)
	# targetWb = copy(wb)
	
	# ws0 = targetWb.get_sheet(1)
	# ws1 = targetWb.get_sheet(2)
	# ws2 = targetWb.get_sheet(3)
	w0 = wb.get_sheet_by_name("Facility Info")
	w1 = wb.get_sheet_by_name("NTG (MW)")
	w2 = wb.get_sheet_by_name("State 1 Loss (MW)")
	w3 = wb.get_sheet_by_name("State 2 Loss (MW)")
	
	wsrd0 = wb_readonly.get_sheet_by_name("Facility Info")
	wsrd1 = wb_readonly.get_sheet_by_name("NTG (MW)")
	wsrd2 = wb_readonly.get_sheet_by_name("State 1 Loss (MW)")
	wsrd3 = wb_readonly.get_sheet_by_name("State 2 Loss (MW)")

	mpids = []
	
	print outResults
	# sys.exit()
	
	for date in outResults.keys():
		mpids = outResults[date].keys()
		break
	
	i = 1
	for mpid in mpids:
		i += 1
		cell_index = 'A' + str(i)
		# mpidName = str(w0[cell_index].value)
		w0[cell_index] = mpid
		print cell_index, mpid
	
	for col in range(col2num('B')+1, wsrd1.max_column):
		cellIndex = openpyxl.utils._get_column_letter(col) + '3' 
		date = (wsrd1[cellIndex].value)
		date = roundTime(date, roundTo=60)
		date = date.strftime("%Y/%m/%d %H:%M")
		# print(col, cellIndex, date)
		
		if date in outResults.keys():
			data = outResults[date]
			index = 3
			for mpid in mpids:
				index += 1
				cell = openpyxl.utils._get_column_letter(col) + str(index)
				if mpid in data.keys():
					val = data[mpid]
					w1[cell] = val[0]
					# print val[0]
					# raw_input()

	for col in range(col2num('B')+1, wsrd2.max_column):
		cellIndex = openpyxl.utils._get_column_letter(col) + '3' 
		date = (wsrd2[cellIndex].value)
		date = roundTime(date, roundTo=60)
		date = date.strftime("%Y/%m/%d %H:%M")
		# print(col, cellIndex, date)
		
		if date in outResults.keys():
			data = outResults[date]
			index = 3
			for mpid in mpids:
				index += 1
				cell = openpyxl.utils._get_column_letter(col) + str(index)
				if mpid in data.keys():
					val = data[mpid]
					w2[cell] = val[1]
					# print val[1]
					# raw_input()	
				break

	for col in range(col2num('B')+1, wsrd3.max_column):
		cellIndex = openpyxl.utils._get_column_letter(col) + '3' 
		date = (wsrd3[cellIndex].value)
		date = roundTime(date, roundTo=60)
		date = date.strftime("%Y/%m/%d %H:%M")
		# print(col, cellIndex, date)
		
		if date in outResults.keys():
			data = outResults[date]
			index = 3
			for mpid in mpids:
				index += 1
				cell = openpyxl.utils._get_column_letter(col) + str(index)
				if mpid in data.keys():
					val = data[mpid]
					w3[cell] = val[2]
					# print val[2]
					# raw_input()
	# wb.save("Output.xlsx")
	wb.save(output_Final)
	

	
def writeFinal(output, mpid, data, wb_result, ws1, ws2, ws3, ws4, ws5, date, writeStart, nextrow, nextDate):
	
	Header = "MPID Names,NTG (MW)"
	if writeStart == 0:
		for col, value in enumerate(Header.split(",")):
			ws1.write(0, col, value)
	Header = "MPID Names,State-1 Loss"
	if writeStart == 0:
		for col, value in enumerate(Header.split(",")):
			ws2.write(0, col, value)
	Header = "MPID Names,State-2 Loss"
	if writeStart == 0:
		for col, value in enumerate(Header.split(",")):
			ws3.write(0, col, value)
	Header = "MPID Names,Marginal Unit-Block Number"
	if writeStart == 0:
		for col, value in enumerate(Header.split(",")):
			ws4.write(0, col, value)
	if writeStart == 0:
		for col, value in enumerate(Header.split(",")):
			ws5.write(0, col, value)
			
	if nextrow == 0:
		ws1.write(1, nextDate, date)
		ws2.write(1, nextDate, date)
		ws3.write(1, nextDate, date)
		ws4.write(1, nextDate, date)
		ws5.write(1, nextDate, date)
		ws2.write(2, nextDate, data[1])
		ws4.write(2, nextDate, data[3])
	
	row = nextrow + 2
	if nextDate == 1:
		ws1.write(row, 0, mpid)
		# ws2.write(row, 0, mpid)
		ws3.write(row, 0, mpid)
		# ws4.write(row, 0, mpid)
		ws5.write(row, 0, mpid)
	
	ws1.write(row, nextDate, data[0])
	
	ws3.write(row, nextDate, data[2])
	ws5.write(row, nextDate, data[4])
	
	wb_result.save(output)
	
	nextrow += 1
	return nextrow
 
def Write(output, mpid, data, wb, ws, writeStart):
	# wb = xlwt.Workbook()
	# ws = wb.add_sheet("Loss Factors")
	row = writeStart+1
	Header = "MPID Name,NTG (state-1),Total AIES Loss (State-1),Total MPID Internal Loss (State-1),Loss (State-1),Marginal Unit (State-1),S1-OWSP, S1-OESP,WATL (State-1), EATL (State-1),NTG (State-2),Total AIES Loss (State-2),Total MPID Internal Loss (state-2),Loss (State-2),Marginal Unit (state-2),S2-OWSP,S2-OESP,WATL (State-2),EATL (State-2),Raw Loss Factor,Margina Unit Block Outside limit (MW),Comments,Solution Check"

	if writeStart == 0:
		for col, value in enumerate(Header.split(",")):
			ws.write(0, col, value)
			# col += col
	
	# col = 0
	# print "MPID", mpid, "row", row 
	# sys.exit()
	# ws.write(row, 0, mpid)
	for col, value in enumerate(Header.split(",")):
		# ws.write(row, col, 'Test')
		ws.write(row, col, data[col])
		
	
	wb.save(output)

######################################
####################
def file_list_(source_path, ext):
	eu = ext.upper()
	base_names = [s for s in os.listdir(source_path) if s.upper().endswith(eu)]
	abs_paths = [os.path.abspath(os.path.join(source_path, s)) for s in base_names]
	return base_names, abs_paths

def ensure_dir(f):
	try:
		os.makedirs(f)
	except OSError:
		if not os.path.isdir(f):
			raise
			
def log_print(log):
	sys.stdout = log
def enable_print():
	sys.stdout = sys.__stdout__

##################################### Main Function ###########
########################################################	
# def ilf_main(caseFiles, GenMappingFiles, EMMOFiles, outputWB, updateEMMO):
# def ilf_main(caseFiles):
def ilf_main(caseFiles, inputdir, s1logfiles):
# def main():
	
	enable_print()

	# dir_emmo = os.path.join(os.getcwd(), 'Input Files\\EMMO')
	# dir_genMapping = os.path.join(os.getcwd(), 'Input Files\\Gen Mapping')
	# dir_emmoCorrection = os.path.join(os.getcwd(), 'Input Files\\EMMO Corrections')
	
	# inputdir = r"C:\Users\sdr\Desktop\ilf\Input Files"
	# print inputdir
	dir_emmo = os.path.join(inputdir, 'EMMO')
	dir_genMapping = os.path.join(inputdir, 'Gen Mapping')
	# dir_emmoCorrection = os.path.join(inputdir, 'EMMO Corrections')
	dir_mulogfiles = os.path.join(os.getcwd(), 'Logfiles')
	
	print "============"
	print "Input Folders :"
	print dir_emmo
	print dir_genMapping
	# print dir_emmoCorrection
	# print dir_mulogfiles

	outputWB = ''
	
	
	filesnames, GenMappingFiles = file_list_(dir_genMapping, ".xlsx")
	filesnames, EMMOFiles = file_list_(dir_emmo, ".xlsx")
	# fnames, munitlogfiles = file_list_(dir_mulogfiles, ".log")
	# filesnames, updateEMMO = file_list_(dir_emmoCorrection, ".xlsx")

	# for file in caseFiles:
		# print file
	# for file in GenMappingFiles:
		# print file
	# for file in EMMOFiles:
		# print file
	# for file in munitlogfiles:
		# print file

	
	global flowTolerance
	global iterationLimit
	global roundingdecimalpoint
	flowTolerance = 0.005
	iterationLimit = 50
	roundingdecimalpoint = 2
	global ab_bc
	ab_bc = [[329, 819, '87'], [232, 1501, '86'], [456, 90000, '01']]
	

	ProcessCases(caseFiles, GenMappingFiles, EMMOFiles, outputWB, s1logfiles)
	enable_print()
	print "++++++++++++++++++++++++++++++++++++ END OF PROGRAM +++++++++++++++++++++++++++++++++++"
	print "++++++++++++++++++++++++++++++++++++ END OF PROGRAM +++++++++++++++++++++++++++++++++++"
	print "++++++++++++++++++++++++++++++++++++ END OF PROGRAM +++++++++++++++++++++++++++++++++++"
	print "++++++++++++++++++++++++++++++++++++ END OF PROGRAM +++++++++++++++++++++++++++++++++++"


# main()
# if __name__ == "__main__":
    # main()